/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.recommend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.cnri.recommend.WeightedTermVector;

public class VectorUtil {
    public static Map<String, Double> sumTermVectors(Map<String, Double> a, Map<String, Double> b) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        result.putAll(a);
        for (Map.Entry<String, Double> entry : b.entrySet()) {
            String key = entry.getKey();
            Double resultValue = (Double)result.get(key);
            double bValue = b.get(key);
            if (resultValue == null) {
                result.put(key, bValue);
                continue;
            }
            double sum = resultValue + bValue;
            result.put(key, sum);
        }
        return result;
    }

    public static Map<String, Double> sumTermVectors(List<Map<String, Double>> vectors) {
        Map<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < vectors.size(); ++i) {
            Map<String, Double> v = vectors.get(i);
            if (i == 0) {
                result.putAll(v);
                continue;
            }
            result = VectorUtil.sumTermVectors(result, v);
        }
        return result;
    }

    public static Map<String, Double> sumWeightedTermVectors(List<WeightedTermVector> wVectors) {
        ArrayList<Map<String, Double>> vectors = new ArrayList<Map<String, Double>>();
        for (WeightedTermVector wVector : wVectors) {
            Map<String, Double> vector = VectorUtil.normalizeTermVector(wVector.termVector);
            vector = VectorUtil.multiplyTermVector(vector, wVector.weight);
            vectors.add(vector);
        }
        Map<String, Double> result = VectorUtil.sumTermVectors(vectors);
        return result;
    }

    public static Map<String, Double> multiplyTermVector(Map<String, Double> v, Double weight) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : v.entrySet()) {
            String key = entry.getKey();
            double value = entry.getValue();
            double weightedValue = value * weight;
            result.put(key, weightedValue);
        }
        return result;
    }

    public static Map<String, Double> normalizeTermVector(Map<String, Double> v) {
        Double runningSumOfSquares = 0.0;
        for (Map.Entry<String, Double> entry : v.entrySet()) {
            double value = entry.getValue();
            double square = value * value;
            runningSumOfSquares = runningSumOfSquares + square;
        }
        double weight = 1.0 / Math.sqrt(runningSumOfSquares);
        Map<String, Double> result = VectorUtil.multiplyTermVector(v, weight);
        return result;
    }

    public static List<Map<String, Double>> normalizeTermVectors(Collection<Map<String, Double>> vectors) {
        ArrayList<Map<String, Double>> resultList = new ArrayList<Map<String, Double>>();
        for (Map<String, Double> v : vectors) {
            Map<String, Double> nv = VectorUtil.normalizeTermVector(v);
            resultList.add(nv);
        }
        return resultList;
    }

    public static Map<String, Map<String, Double>> normalizeTermVectors(Map<String, Map<String, Double>> namedVectors) {
        HashMap<String, Map<String, Double>> resultMap = new HashMap<String, Map<String, Double>>();
        for (String name : namedVectors.keySet()) {
            Map<String, Double> v = namedVectors.get(name);
            Map<String, Double> nv = VectorUtil.normalizeTermVector(v);
            resultMap.put(name, nv);
        }
        return resultMap;
    }

    public static Map<String, Double> normalizeAndSumTermVectors(Collection<Map<String, Double>> vectors) {
        List<Map<String, Double>> normalizedVectors = VectorUtil.normalizeTermVectors(vectors);
        Map<String, Double> result = VectorUtil.sumTermVectors(normalizedVectors);
        return result;
    }
}

