/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.recommend;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.cnri.cordra.api.BadRequestCordraException;
import net.cnri.cordra.api.CordraClient;
import net.cnri.cordra.api.CordraException;
import net.cnri.cordra.api.CordraObject;
import net.cnri.cordra.api.SearchResults;
import net.cnri.cordra.api.TokenUsingHttpCordraClient;
import net.cnri.recommend.Recommender;
import org.apache.solr.client.solrj.SolrClient;

public class RecommenderService {
    private final CordraClient cordra;
    private final SolrClient solr;
    private final String cordraBaseUri;
    private final boolean enableSimilarProfileMode;

    public RecommenderService(String cordraBaseUri, CordraClient cordra, SolrClient solr, boolean enableSimilarProfileMode) {
        this.cordraBaseUri = cordraBaseUri;
        this.cordra = cordra;
        this.solr = solr;
        this.enableSimilarProfileMode = enableSimilarProfileMode;
    }

    public void rateItem(String userId, String itemId, Integer rating, String username, String password) throws Exception {
        try (TokenUsingHttpCordraClient cordraClient = new TokenUsingHttpCordraClient(this.cordraBaseUri, username, password);){
            if (rating != null && (rating < 1 || rating > 5)) {
                throw new BadRequestCordraException("Rating must be between 1 and 5 inclusive");
            }
            CordraObject userCo = cordraClient.get(userId, username, password);
            if (userCo == null) {
                throw new BadRequestCordraException("There is no user " + userId);
            }
            JsonObject user = userCo.content.getAsJsonObject();
            CordraObject itemCo = cordraClient.get(itemId, username, password);
            if (itemCo == null) {
                throw new BadRequestCordraException("There is no item " + itemId);
            }
            if ("User".equals(itemCo.type)) {
                throw new BadRequestCordraException("The system does not support Users rating User objects. The item your rated is of type User");
            }
            JsonObject item = itemCo.content.getAsJsonObject();
            this.addItemRatingToUserJson(user, item, itemId, rating);
            userCo.setContent((Object)user);
            cordraClient.update(userCo, username, password);
        }
    }

    public void deleteRating(String userId, String itemId, String username, String password) throws Exception {
        try (TokenUsingHttpCordraClient cordraClient = new TokenUsingHttpCordraClient(this.cordraBaseUri, username, password);){
            CordraObject userCo = cordraClient.get(userId, username, password);
            if (userCo == null) {
                throw new BadRequestCordraException("There is no user " + userId);
            }
            JsonObject user = userCo.content.getAsJsonObject();
            if (!user.has("itemRatings")) {
                throw new BadRequestCordraException("User " + userId + " has not rated item " + itemId);
            }
            JsonArray itemRatings = user.getAsJsonArray("itemRatings");
            int position = this.positionOfRatedItem(itemRatings, itemId);
            if (position == -1) {
                throw new BadRequestCordraException("User " + userId + " has not rated item " + itemId);
            }
            itemRatings.remove(position);
            userCo.setContent((Object)user);
            cordraClient.update(userCo, username, password);
        }
    }

    private void addItemRatingToUserJson(JsonObject user, JsonObject item, String itemId, Integer rating) {
        JsonArray itemRatings;
        JsonObject itemRating = new JsonObject();
        itemRating.addProperty("id", itemId);
        if (rating != null) {
            itemRating.addProperty("rating", (Number)rating);
        }
        if (item != null && this.enableSimilarProfileMode) {
            itemRating.add("item", (JsonElement)item);
        }
        if (user.has("itemRatings")) {
            itemRatings = user.getAsJsonArray("itemRatings");
        } else {
            itemRatings = new JsonArray();
            user.add("itemRatings", (JsonElement)itemRatings);
        }
        int existingPosition = this.positionOfRatedItem(itemRatings, itemId);
        if (existingPosition == -1) {
            itemRatings.add((JsonElement)itemRating);
        } else {
            itemRatings.set(existingPosition, (JsonElement)itemRating);
        }
    }

    private int positionOfRatedItem(JsonArray itemRatings, String itemId) {
        for (int i = 0; i < itemRatings.size(); ++i) {
            if (!itemId.equals(itemRatings.get(i).getAsJsonObject().get("id").getAsString())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasRatedItem(JsonArray itemRatings, String itemId) {
        for (int i = 0; i < itemRatings.size(); ++i) {
            if (!itemId.equals(itemRatings.get(i).getAsJsonObject().get("id").getAsString())) continue;
            return true;
        }
        return false;
    }

    private SearchResults<CordraObject> searchForRecommendations(String userId, CordraClient cordraClient, List<String> limitedFields, boolean boost, Mode mode) throws Exception {
        if (mode == Mode.SIMPLE_CONTENT_BASED) {
            return Recommender.getSimpleContentBasedPersonalRecommendations(userId, cordraClient, this.solr, limitedFields, boost);
        }
        return Recommender.getSimilarProfileBasedRecommendations(userId, cordraClient, this.solr, limitedFields, boost);
    }

    public List<String> getRecommendations(String userId, int num, boolean boost, Mode mode, String username, String password) throws Exception {
        List<String> limitedFields = null;
        ArrayList<String> ids = new ArrayList<String>();
        try (TokenUsingHttpCordraClient cordraClient = new TokenUsingHttpCordraClient(this.cordraBaseUri, username, password);){
            CordraObject userCo = cordraClient.get(userId);
            JsonObject profile = userCo.content.getAsJsonObject();
            if (profile.has("itemRatings")) {
                JsonArray itemRatings = profile.get("itemRatings").getAsJsonArray();
                if (itemRatings.size() == 0) {
                    ArrayList<String> arrayList = ids;
                    return arrayList;
                }
            } else {
                ArrayList<String> itemRatings = ids;
                return itemRatings;
            }
            try (SearchResults<CordraObject> results = this.searchForRecommendations(userId, (CordraClient)cordraClient, limitedFields, boost, mode);){
                int count = 0;
                for (CordraObject co : results) {
                    ids.add(co.id);
                    if (++count != num) continue;
                    break;
                }
            }
        }
        return ids;
    }

    public String getUserIdForUsername(String username) throws CordraException {
        String userId = null;
        String q = "username:\"" + username + "\"";
        try (SearchResults results = this.cordra.search(q);){
            for (CordraObject co : results) {
                String foundUsername = co.content.getAsJsonObject().get("username").getAsString();
                if (!username.equalsIgnoreCase(foundUsername)) continue;
                userId = co.id;
            }
        }
        return userId;
    }

    private void throwIfNotAllExists(List<String> ids, CordraClient cordraClient) throws Exception {
        for (String id : ids) {
            this.throwIfNotExists(id, cordraClient);
        }
    }

    private void throwIfNotExists(String id, CordraClient cordraClient) throws Exception {
        if (cordraClient.get(id) == null) {
            throw new BadRequestCordraException("id: " + id + " does not exist");
        }
    }

    public List<String> getMoreLikeThis(String userId, List<String> ids, String username, String password, int num) throws Exception {
        try (TokenUsingHttpCordraClient cordraClient = new TokenUsingHttpCordraClient(this.cordraBaseUri, username, password);){
            ArrayList<String> arrayList;
            block12: {
                this.throwIfNotAllExists(ids, (CordraClient)cordraClient);
                SearchResults<CordraObject> results = Recommender.moreLikeThis(ids, (CordraClient)cordraClient, this.solr);
                try {
                    int count = 0;
                    ArrayList<String> result = new ArrayList<String>();
                    for (CordraObject co : results) {
                        result.add(co.id);
                        if (++count != num) continue;
                        break;
                    }
                    arrayList = result;
                    if (results == null) break block12;
                }
                catch (Throwable throwable) {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                results.close();
            }
            return arrayList;
        }
    }

    public static enum Mode {
        SIMPLE_CONTENT_BASED,
        SIMILAR_PROFILE_BASED;

    }
}

