/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.recommend;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.cnri.cordra.api.CordraClient;
import net.cnri.cordra.api.CordraException;
import net.cnri.cordra.api.CordraObject;
import net.cnri.cordra.api.HttpCordraClient;
import net.cnri.cordra.api.SearchResults;
import net.cnri.recommend.MoreLikeThis;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;

public class Recommender {
    public static final int THREADS = 16;
    private static AtomicInteger progress = new AtomicInteger(0);

    public static SearchResults<CordraObject> getSimilarProfileBasedRecommendations(String profileId, CordraClient cordra, SolrClient solr, List<String> limitedFields, boolean useRatingsBoost) throws Exception {
        CordraObject co = cordra.get(profileId);
        JsonObject profile = co.content.getAsJsonObject();
        JsonArray itemRatings = profile.get("itemRatings").getAsJsonArray();
        if (itemRatings == null || itemRatings.size() == 0) {
            return null;
        }
        List<String> ids = Collections.singletonList(profileId);
        Map<String, Map<String, Double>> termVectorsMap = MoreLikeThis.getTermVectors(ids, solr, null);
        String similarProfilesQueryString = MoreLikeThis.buildMoreLikeThisQueryFor(termVectorsMap.values(), true);
        String excludeIds = MoreLikeThis.generateExcludeIdsQueryFragment(ids);
        similarProfilesQueryString = similarProfilesQueryString + excludeIds;
        similarProfilesQueryString = MoreLikeThis.fixSlashes(similarProfilesQueryString);
        similarProfilesQueryString = Recommender.escapeTildes(similarProfilesQueryString);
        SolrQuery query = new SolrQuery(similarProfilesQueryString);
        query.set("fl", new String[]{"score,id"});
        QueryResponse queryResponse = solr.query((SolrParams)query);
        if (queryResponse.getStatus() != 0) {
            throw new Exception("Unexpected Solr response " + queryResponse);
        }
        SolrDocumentList profilesDocumentList = queryResponse.getResults();
        ArrayList<String> similarProfileIds = new ArrayList<String>();
        int similarProfileLimit = 5;
        for (int i = 0; i < profilesDocumentList.size(); ++i) {
            SolrDocument solrProfile = (SolrDocument)profilesDocumentList.get(i);
            String id = (String)solrProfile.getFieldValue("id");
            similarProfileIds.add(id);
            if (i == similarProfileLimit) break;
        }
        Map<String, Map<String, Double>> similarUsersItemRatings = Recommender.getUserItemRatingsFor(similarProfileIds, cordra);
        Map<String, Double> thisUserItemRatings = Recommender.getItemRatingMap(profile);
        HashSet<String> allRatedItemIds = new HashSet<String>();
        for (String similarUserId : similarUsersItemRatings.keySet()) {
            Map<String, Double> similarUserItemRatings = similarUsersItemRatings.get(similarUserId);
            allRatedItemIds.addAll(similarUserItemRatings.keySet());
        }
        allRatedItemIds.addAll(thisUserItemRatings.keySet());
        ArrayList<String> allRatedItemIdsAsList = new ArrayList<String>();
        allRatedItemIdsAsList.addAll(allRatedItemIds);
        Map<String, Map<String, Double>> similarItemsTermVectorsMap = MoreLikeThis.getTermVectors(allRatedItemIdsAsList, solr, limitedFields);
        String queryBasedOnSimilarProfiles = null;
        if (useRatingsBoost) {
            Map<String, Double> boostItemRatingMap = Recommender.getAvgBoostMap(similarUsersItemRatings, thisUserItemRatings);
            queryBasedOnSimilarProfiles = MoreLikeThis.buildMoreLikeThisQueryForWithBoosts(similarItemsTermVectorsMap, boostItemRatingMap);
        } else {
            Collection<Map<String, Double>> itemTerms = similarItemsTermVectorsMap.values();
            queryBasedOnSimilarProfiles = MoreLikeThis.buildMoreLikeThisQueryFor(itemTerms, true);
        }
        ArrayList<String> likedIds = new ArrayList<String>();
        for (int i = 0; i < itemRatings.size(); ++i) {
            JsonObject itemRating = itemRatings.get(i).getAsJsonObject();
            String id = itemRating.get("id").getAsString();
            likedIds.add(id);
        }
        ArrayList<String> idsThisUserHadAlreadyRatedExcludeIds = likedIds;
        String excludeItemIds = Recommender.generateExcludeDoisQueryFragment(idsThisUserHadAlreadyRatedExcludeIds);
        queryBasedOnSimilarProfiles = queryBasedOnSimilarProfiles + excludeItemIds;
        queryBasedOnSimilarProfiles = "(" + queryBasedOnSimilarProfiles + ") -type:User -type:Schema";
        return cordra.search(queryBasedOnSimilarProfiles);
    }

    private static Map<String, Double> getWeightedAvgBoostMap(Map<String, Map<String, Double>> similarUsersItemRatings, Map<String, Double> thisUserItemRatings, double similarUsersWeight, double userWeight) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        HashMap<String, Double> sumMap = new HashMap<String, Double>();
        for (String profileId : similarUsersItemRatings.keySet()) {
            Map<String, Double> itemRatings = similarUsersItemRatings.get(profileId);
            for (String itemId : itemRatings.keySet()) {
                Double rating = itemRatings.get(itemId);
                Recommender.count(countMap, itemId);
                Recommender.sum(sumMap, itemId, rating * similarUsersWeight);
            }
        }
        for (String itemId : thisUserItemRatings.keySet()) {
            Double rating = thisUserItemRatings.get(itemId);
            Recommender.count(countMap, itemId);
            Recommender.sum(sumMap, itemId, rating * userWeight);
        }
        HashMap<String, Double> avgRatingMap = new HashMap<String, Double>();
        for (String itemId : countMap.keySet()) {
            Integer count = (Integer)countMap.get(itemId);
            Double sum = (Double)sumMap.get(itemId);
            Double avg = sum / (double)count.intValue();
            avgRatingMap.put(itemId, avg);
        }
        return avgRatingMap;
    }

    private static Map<String, Double> getAvgBoostMap(Map<String, Map<String, Double>> similarUsersItemRatings, Map<String, Double> thisUserItemRatings) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        HashMap<String, Double> sumMap = new HashMap<String, Double>();
        for (String profileId : similarUsersItemRatings.keySet()) {
            Map<String, Double> itemRatings = similarUsersItemRatings.get(profileId);
            for (String itemId : itemRatings.keySet()) {
                Double rating = itemRatings.get(itemId);
                Recommender.count(countMap, itemId);
                Recommender.sum(sumMap, itemId, rating);
            }
        }
        for (String itemId : thisUserItemRatings.keySet()) {
            Double rating = thisUserItemRatings.get(itemId);
            Recommender.count(countMap, itemId);
            Recommender.sum(sumMap, itemId, rating);
        }
        HashMap<String, Double> avgRatingMap = new HashMap<String, Double>();
        for (String itemId : countMap.keySet()) {
            Integer count = (Integer)countMap.get(itemId);
            Double sum = (Double)sumMap.get(itemId);
            Double avg = sum / (double)count.intValue();
            avgRatingMap.put(itemId, avg);
        }
        return avgRatingMap;
    }

    private static void count(Map<String, Integer> countMap, String itemId) {
        Integer count = countMap.get(itemId);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        countMap.put(itemId, count);
    }

    private static void sum(Map<String, Double> sumMap, String itemId, Double value) {
        Double sum = sumMap.get(itemId);
        if (sum == null) {
            sum = 0.0;
        }
        sum = sum + value;
        sumMap.put(itemId, sum);
    }

    private static Map<String, Map<String, Double>> getUserItemRatingsFor(List<String> profileIds, CordraClient cordra) throws CordraException {
        HashMap<String, Map<String, Double>> userItemRatings = new HashMap<String, Map<String, Double>>();
        for (String profileId : profileIds) {
            CordraObject profileCo = cordra.get(profileId);
            JsonObject profile = profileCo.content.getAsJsonObject();
            Map<String, Double> itemRatingMap = Recommender.getItemRatingMap(profile);
            userItemRatings.put(profileId, itemRatingMap);
        }
        return userItemRatings;
    }

    private static String escapeTildes(String similarProfilesQueryString) {
        return similarProfilesQueryString.replace("~", "\\~");
    }

    public static String generateExcludeDoisQueryFragment(List<String> ids) {
        return " -id:" + String.join((CharSequence)" -id:", ids);
    }

    public static void main(String[] args) throws Exception {
        String solrBaseUri = "http://big.local:8983/solr/cordra";
        HttpSolrClient solr = new HttpSolrClient.Builder().withBaseSolrUrl(solrBaseUri).build();
        String cordraBaseUri = "http://big.local:8082/cordra/";
        HttpCordraClient cordra = new HttpCordraClient(cordraBaseUri, "admin", "password");
        int numResults = 10;
        boolean useRatingsBoost = true;
        try (SearchResults<CordraObject> results = Recommender.getSimilarProfileBasedRecommendations("test/UserProfile-281987729.1505441025", (CordraClient)cordra, (SolrClient)solr, null, useRatingsBoost);){
            int count = 1;
            for (CordraObject co : results) {
                System.out.println(co.id);
                if (++count <= numResults) continue;
                break;
            }
        }
        System.out.println();
    }

    public static Map<String, List<String>> generateRecommendationsForAllSimilarProfileBased(SolrClient solr, CordraClient cordra, int numResults, List<String> limitedFields, boolean useRatingsBoost) throws CordraException, Exception {
        HashMap<String, List<String>> recommendationsMap = new HashMap<String, List<String>>();
        List<String> profileIds = Recommender.getProfileIdsList(cordra);
        ExecutorService exec = Executors.newFixedThreadPool(16);
        int total = profileIds.size();
        for (String profileId : profileIds) {
            ArrayList userRecommendations = new ArrayList();
            recommendationsMap.put(profileId, userRecommendations);
            exec.submit(() -> {
                try (SearchResults<CordraObject> results = Recommender.getSimilarProfileBasedRecommendations(profileId, cordra, solr, limitedFields, useRatingsBoost);){
                    int count = 1;
                    for (CordraObject co : results) {
                        userRecommendations.add(co.id);
                        if (++count <= numResults) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Recommender.printProgress(total, profileId);
            });
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return recommendationsMap;
    }

    public static synchronized void printProgress(int total, String id) {
        int count = progress.incrementAndGet();
    }

    public static List<String> getProfileIdsList(CordraClient cordra) throws CordraException {
        ArrayList<String> profileIds = new ArrayList<String>();
        try (SearchResults profileIdsResults = cordra.searchHandles("type:User");){
            for (String profileId : profileIdsResults) {
                profileIds.add(profileId);
            }
        }
        return profileIds;
    }

    public static Map<String, List<String>> generateRecommendationsForAllSimpleContentBased(SolrClient solr, CordraClient cordra, int numResults, List<String> limitedFields, boolean useRatingsBoost) throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(16);
        HashMap<String, List<String>> recommendationsMap = new HashMap<String, List<String>>();
        List<String> profileIds = Recommender.getProfileIdsList(cordra);
        int total = profileIds.size();
        for (String profileId : profileIds) {
            ArrayList userRecommendations = new ArrayList();
            recommendationsMap.put(profileId, userRecommendations);
            exec.submit(() -> {
                try (SearchResults<CordraObject> results = Recommender.getSimpleContentBasedPersonalRecommendations(profileId, cordra, solr, limitedFields, useRatingsBoost);){
                    int count = 1;
                    for (CordraObject co : results) {
                        userRecommendations.add(co.id);
                        if (++count <= numResults) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Recommender.printProgress(total, profileId);
            });
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return recommendationsMap;
    }

    public static SearchResults<CordraObject> getSimpleContentBasedPersonalRecommendations(String profileId, CordraClient cordra, SolrClient solr, List<String> limitedFields, boolean useRatingsBoost) throws Exception {
        ArrayList<String> likedIds = new ArrayList<String>();
        CordraObject profileCo = cordra.get(profileId);
        JsonObject profile = profileCo.content.getAsJsonObject();
        JsonArray itemRatings = profile.get("itemRatings").getAsJsonArray();
        for (int i = 0; i < itemRatings.size(); ++i) {
            JsonObject itemRating = itemRatings.get(i).getAsJsonObject();
            String id = itemRating.get("id").getAsString();
            likedIds.add(id);
        }
        Map<String, Map<String, Double>> termVectorsMap = MoreLikeThis.getTermVectors(likedIds, solr, limitedFields);
        String queryString = null;
        if (useRatingsBoost) {
            Map<String, Double> itemRatingMap = Recommender.getItemRatingMap(profile);
            queryString = MoreLikeThis.buildMoreLikeThisQueryForWithBoosts(termVectorsMap, itemRatingMap);
        } else {
            queryString = MoreLikeThis.buildMoreLikeThisQueryFor(termVectorsMap.values(), true);
        }
        String excludeIdsQueryFragment = MoreLikeThis.generateExcludeIdsQueryFragment(likedIds);
        queryString = queryString + excludeIdsQueryFragment;
        queryString = MoreLikeThis.fixSlashes(queryString);
        queryString = "(" + queryString + ") -type:User -type:Schema";
        return cordra.search(queryString);
    }

    private static Map<String, Double> getItemRatingMap(JsonObject profile) {
        HashMap<String, Double> itemRatingMap = new HashMap<String, Double>();
        JsonElement ratingsElem = profile.get("itemRatings");
        if (ratingsElem != null) {
            JsonArray itemRatings = ratingsElem.getAsJsonArray();
            for (int i = 0; i < itemRatings.size(); ++i) {
                JsonObject itemRating = itemRatings.get(i).getAsJsonObject();
                String id = itemRating.get("id").getAsString();
                Double rating = itemRating.has("rating") ? Double.valueOf(itemRating.get("rating").getAsDouble()) : Double.valueOf(1.0);
                itemRatingMap.put(id, rating);
            }
        }
        return itemRatingMap;
    }

    public static Double scaleRatingToBoostFactor(Double rating) {
        return rating;
    }

    public static void boostTermVectorsByRatings(Map<String, Double> itemRatingMap, Map<String, Map<String, Double>> termVectorsMap) {
        for (String itemId : itemRatingMap.keySet()) {
            Double rating = itemRatingMap.get(itemId);
            Double boost = Recommender.scaleRatingToBoostFactor(rating);
            Map<String, Double> termVector = termVectorsMap.get(itemId);
            for (String term : termVector.keySet()) {
                Double magnitude = termVector.get(term);
                Double boostedMagnitude = magnitude * boost;
                termVector.put(term, boostedMagnitude);
            }
        }
    }

    public static SearchResults<CordraObject> moreLikeThis(List<String> ids, CordraClient cordra, SolrClient solr) throws Exception {
        String queryString = MoreLikeThis.getMoreLikeThis(ids, solr);
        String excludeIdsQueryFragment = MoreLikeThis.generateExcludeIdsQueryFragment(ids);
        queryString = queryString + excludeIdsQueryFragment;
        queryString = MoreLikeThis.fixSlashes(queryString);
        return cordra.search(queryString);
    }
}

