/*
 * Decompiled with CFR 0.152.
 */
package net.cloudopt.next.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.cloudopt.next.auth.bean.Group;
import net.cloudopt.next.auth.bean.Role;
import net.cloudopt.next.auth.bean.Rule;
import net.cloudopt.next.auth.bean.User;
import net.cloudopt.next.auth.utils.RuleMatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u000bH&J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H&J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000bH&J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0019H&J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020\nH&J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u000bH&J\u0006\u0010#\u001a\u00020$R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004RB\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tj\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lnet/cloudopt/next/auth/Auth;", "", "cache", "", "(Z)V", "getCache", "()Z", "setCache", "cacheMap", "Ljava/util/LinkedHashMap;", "", "", "Lnet/cloudopt/next/auth/bean/Rule;", "Lkotlin/collections/LinkedHashMap;", "getCacheMap", "()Ljava/util/LinkedHashMap;", "setCacheMap", "(Ljava/util/LinkedHashMap;)V", "enforce", "uniqueTag", "url", "method", "getGroup", "Lnet/cloudopt/next/auth/bean/Group;", "groupId", "", "getGroups", "getRole", "Lnet/cloudopt/next/auth/bean/Role;", "roleId", "getRoles", "getUser", "Lnet/cloudopt/next/auth/bean/User;", "userId", "getUsers", "refreshCache", "", "cloudopt-next-auth"})
public abstract class Auth {
    private boolean cache;
    @NotNull
    private LinkedHashMap<String, List<Rule>> cacheMap;

    public final boolean getCache() {
        return this.cache;
    }

    public final void setCache(boolean bl) {
        this.cache = bl;
    }

    @NotNull
    public final LinkedHashMap<String, List<Rule>> getCacheMap() {
        return this.cacheMap;
    }

    public final void setCacheMap(@NotNull LinkedHashMap<String, List<Rule>> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, (String)"<set-?>");
        this.cacheMap = linkedHashMap;
    }

    public Auth(boolean cache) {
        this.cache = true;
        this.cacheMap = new LinkedHashMap();
        this.cache = cache;
        if (cache) {
            this.refreshCache();
        }
    }

    public /* synthetic */ Auth(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final void refreshCache() {
        List<User> users = this.getUsers();
        for (User user : users) {
            LinkedList<Rule> it;
            boolean bl;
            boolean bl2;
            LinkedList<Rule> linkedList;
            LinkedList<Rule> linkedList2;
            Object object;
            if (!this.cache) continue;
            List tempRuleMap = null;
            Object object2 = this.cacheMap.get(user.getUniqueTag());
            Object object3 = object2 == null ? (List)user.getRules() : object2;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"cacheMap[user.uniqueTag] ?: user.rules");
            tempRuleMap = object3;
            object3 = user.getRolesIdList().iterator();
            while (object3.hasNext()) {
                int roleId = ((Number)object3.next()).intValue();
                object = this.getRole(roleId);
                if (object == null || (linkedList2 = ((Role)object).getRules()) == null) continue;
                linkedList = linkedList2;
                bl2 = false;
                bl = false;
                it = linkedList;
                boolean bl3 = false;
                tempRuleMap.addAll((Collection)it);
            }
            object3 = user.getGroupsIdList().iterator();
            while (object3.hasNext()) {
                int groupId = ((Number)object3.next()).intValue();
                object = this.getGroup(groupId);
                if (object == null || (linkedList2 = ((Group)object).getRules()) == null) continue;
                linkedList = linkedList2;
                bl2 = false;
                bl = false;
                it = linkedList;
                boolean bl4 = false;
                tempRuleMap.addAll((Collection)it);
            }
            object3 = this.cacheMap;
            object2 = user.getUniqueTag();
            object = tempRuleMap;
            boolean bl5 = false;
            object3.put(object2, object);
        }
    }

    @NotNull
    public abstract List<Role> getRoles();

    @Nullable
    public abstract Role getRole(int var1);

    @NotNull
    public abstract List<Group> getGroups();

    @Nullable
    public abstract Group getGroup(int var1);

    @NotNull
    public abstract List<User> getUsers();

    @Nullable
    public abstract User getUser(int var1);

    @Nullable
    public abstract User getUser(@NotNull String var1);

    public final boolean enforce(@NotNull String uniqueTag, @NotNull String url, @NotNull String method) {
        LinkedList<Rule> it;
        boolean bl;
        boolean bl2;
        LinkedList<Rule> linkedList;
        LinkedList<Rule> linkedList2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)uniqueTag, (String)"uniqueTag");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.cacheMap.containsKey(uniqueTag)) {
            List list;
            List list2 = this.cacheMap.get(uniqueTag);
            if (list2 == null) {
                boolean bl3 = false;
                list = new ArrayList();
            } else {
                list = list2;
            }
            return RuleMatch.INSTANCE.ruleMatch(url, method, list);
        }
        User user = this.getUser(uniqueTag);
        if (user == null) {
            return false;
        }
        User user2 = user;
        List tempRuleMap = null;
        List list = this.cacheMap.get(user2.getUniqueTag());
        Iterator<Integer> iterator = list == null ? (List)user2.getRules() : list;
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"cacheMap[user.uniqueTag] ?: user.rules");
        tempRuleMap = iterator;
        iterator = user2.getRolesIdList().iterator();
        while (iterator.hasNext()) {
            int roleId = ((Number)iterator.next()).intValue();
            object = this.getRole(roleId);
            if (object == null || (linkedList2 = ((Role)object).getRules()) == null) continue;
            linkedList = linkedList2;
            bl2 = false;
            bl = false;
            it = linkedList;
            boolean bl4 = false;
            tempRuleMap.addAll((Collection)it);
        }
        iterator = user2.getGroupsIdList().iterator();
        while (iterator.hasNext()) {
            int groupId = ((Number)iterator.next()).intValue();
            object = this.getGroup(groupId);
            if (object == null || (linkedList2 = ((Group)object).getRules()) == null) continue;
            linkedList = linkedList2;
            bl2 = false;
            bl = false;
            it = linkedList;
            boolean bl5 = false;
            tempRuleMap.addAll((Collection)it);
        }
        return RuleMatch.INSTANCE.ruleMatch(url, method, tempRuleMap);
    }
}

