/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public final class KeepLargestBlockFilter
implements BoilerpipeFilter {
    public static final KeepLargestBlockFilter INSTANCE = new KeepLargestBlockFilter(false);
    public static final KeepLargestBlockFilter INSTANCE_EXPAND_TO_SAME_TAGLEVEL = new KeepLargestBlockFilter(true);
    private final boolean expandToSameLevelText;

    public KeepLargestBlockFilter(boolean expandToSameLevelText) {
        this.expandToSameLevelText = expandToSameLevelText;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        int maxNumWords = -1;
        TextBlock largestBlock = null;
        int level = -1;
        int i = 0;
        int n = -1;
        for (TextBlock tb : textBlocks) {
            int nw;
            if (tb.isContent() && (nw = tb.getNumWords()) > maxNumWords) {
                largestBlock = tb;
                maxNumWords = nw;
                n = i;
                if (this.expandToSameLevelText) {
                    level = tb.getTagLevel();
                }
            }
            ++i;
        }
        for (TextBlock tb : textBlocks) {
            if (tb == largestBlock) {
                tb.setIsContent(true);
                continue;
            }
            tb.setIsContent(false);
            tb.addLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT");
        }
        if (this.expandToSameLevelText && n != -1) {
            int tl;
            TextBlock tb;
            ListIterator<TextBlock> it = textBlocks.listIterator(n);
            while (it.hasPrevious() && (tl = (tb = it.previous()).getTagLevel()) >= level) {
                if (tl != level) continue;
                tb.setIsContent(true);
            }
            it = textBlocks.listIterator(n);
            while (it.hasNext() && (tl = (tb = it.next()).getTagLevel()) >= level) {
                if (tl != level) continue;
                tb.setIsContent(true);
            }
        }
        return true;
    }
}

