/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.filters.english.HeuristicFilterBase;
import java.util.List;

public final class KeepLargestFulltextBlockFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final KeepLargestFulltextBlockFilter INSTANCE = new KeepLargestFulltextBlockFilter();

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        int max = -1;
        TextBlock largestBlock = null;
        int index = 0;
        for (TextBlock tb : textBlocks) {
            if (!tb.isContent()) continue;
            int numWords = KeepLargestFulltextBlockFilter.getNumFullTextWords(tb);
            if (numWords > max) {
                largestBlock = tb;
                max = numWords;
            }
            ++index;
        }
        if (largestBlock == null) {
            return false;
        }
        for (TextBlock tb : textBlocks) {
            if (tb == largestBlock) {
                tb.setIsContent(true);
                continue;
            }
            tb.setIsContent(false);
            tb.addLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT");
        }
        return true;
    }
}

