/*
 * Decompiled with CFR 0.152.
 */
package com.cloudburo.grab.webcontent;

import com.cloudburo.grab.webcontent.GrabberRecord;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.extractors.CommonExtractors;
import de.l3s.boilerpipe.sax.HTMLHighlighter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Grabber {
    final HTMLHighlighter hh = HTMLHighlighter.newExtractingInstance();
    static final Logger logger = LoggerFactory.getLogger(Grabber.class);

    public GrabberRecord extractArticle(String inurl, boolean textOnly) throws IOException, BoilerpipeProcessingException, SAXException {
        URL url = new URL(this.resolveGoogleRedirect(inurl));
        String content = this.hh.process(url, CommonExtractors.ARTICLE_EXTRACTOR);
        if (textOnly) {
            Document doc = Jsoup.parse((String)content);
            content = doc.select("BODY").first().text().toString();
        }
        GrabberRecord rec = new GrabberRecord();
        rec.url = url;
        rec.content = content;
        return rec;
    }

    public String extractDefault(String inurl) throws IOException, BoilerpipeProcessingException, SAXException {
        URL url = new URL(this.resolveGoogleRedirect(inurl));
        return this.hh.process(url, CommonExtractors.DEFAULT_EXTRACTOR);
    }

    public String extractCanloa(String inurl) throws IOException, BoilerpipeProcessingException, SAXException {
        URL url = new URL(this.resolveGoogleRedirect(inurl));
        return this.hh.process(url, CommonExtractors.CANOLA_EXTRACTOR);
    }

    public String extractLargestContent(String inurl) throws IOException, BoilerpipeProcessingException, SAXException {
        URL url = new URL(this.resolveGoogleRedirect(inurl));
        return this.hh.process(url, CommonExtractors.LARGEST_CONTENT_EXTRACTOR);
    }

    private String resolveGoogleRedirect(String url) throws MalformedURLException {
        if (url.contains("www.google.com/url")) {
            url = this.getQueryMap(new URL(url)).get("url");
        }
        logger.debug("Fetching with URL: " + url);
        return url;
    }

    private Map<String, String> getQueryMap(URL url) {
        String[] params = url.getQuery().split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }
}

