/*
 * Decompiled with CFR 0.152.
 */
package com.onehilltech.promises;

import com.onehilltech.promises.Promise;

class ContinuationPromise<T>
extends Promise<T> {
    ContinuationPromise() {
        super(null);
    }

    void continueWith(Promise<T> promise) {
        if (promise != null) {
            switch (promise.getStatus()) {
                case Resolved: {
                    this.onResolve(promise.getValue());
                    break;
                }
                case Rejected: {
                    this.onReject(promise.getRejection());
                    break;
                }
                default: {
                    promise.then(ContinuationPromise.resolved(this::onResolve), ContinuationPromise.rejected(this::onReject));
                    break;
                }
            }
        } else {
            this.continueWithNull();
        }
    }

    void continueWithNull() {
        this.onResolve(null);
    }

    void continueWith(Throwable t) {
        this.onReject(t);
    }
}

