/*
 * Decompiled with CFR 0.152.
 */
package com.onehilltech.promises;

import com.onehilltech.promises.OnRejected;
import com.onehilltech.promises.OnResolved;
import com.onehilltech.promises.Promise;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class AwaitHandler<T>
implements OnResolved<T, Object>,
OnRejected {
    private final Lock lock_ = new ReentrantLock();
    private final Condition isSettled_ = this.lock_.newCondition();
    private T value_;
    private Throwable reason_;
    private boolean settled_ = false;

    AwaitHandler() {
    }

    @Override
    public Promise<Object> onResolved(T value) {
        this.settle(value, null);
        return null;
    }

    @Override
    public Promise onRejected(Throwable reason) {
        this.settle(null, reason);
        return null;
    }

    private void settle(T value, Throwable reason) {
        this.lock_.lock();
        try {
            this.settled_ = true;
            this.value_ = value;
            this.reason_ = reason;
            this.isSettled_.signalAll();
        }
        finally {
            this.lock_.unlock();
        }
    }

    final T await() throws Throwable {
        this.lock_.lock();
        try {
            if (this.settled_) {
                if (this.reason_ != null) {
                    throw this.reason_;
                }
                T t = this.value_;
                return t;
            }
            this.await(this.isSettled_);
            if (this.reason_ != null) {
                throw this.reason_;
            }
            T t = this.value_;
            return t;
        }
        finally {
            this.lock_.unlock();
        }
    }

    protected void await(Condition condition) throws Throwable {
        condition.await();
    }
}

