/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.DefaultHttpStatusCodeProvider;
import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClientException;
import com.googlecode.jsonrpc4j.spring.rest.JsonRpcResponseErrorHandler;
import com.googlecode.jsonrpc4j.spring.rest.MappingJacksonRPC2HttpMessageConverter;
import com.googlecode.jsonrpc4j.spring.rest.SslClientHttpRequestFactory;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class JsonRpcRestClient
extends JsonRpcClient
implements IJsonRpcClient {
    private final AtomicReference<URL> serviceUrl = new AtomicReference();
    private final RestTemplate restTemplate;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final SslClientHttpRequestFactory requestFactory;

    public JsonRpcRestClient(URL serviceUrl) {
        this(serviceUrl, new ObjectMapper());
    }

    private JsonRpcRestClient(URL serviceUrl, ObjectMapper mapper) {
        this(serviceUrl, mapper, null, new HashMap<String, String>());
    }

    public JsonRpcRestClient(URL serviceUrl, ObjectMapper mapper, RestTemplate restTemplate, Map<String, String> headers) {
        super(mapper);
        this.requestFactory = restTemplate != null ? null : new SslClientHttpRequestFactory();
        this.restTemplate = restTemplate != null ? restTemplate : new RestTemplate((ClientHttpRequestFactory)this.requestFactory);
        this.serviceUrl.set(serviceUrl);
        if (headers != null) {
            this.headers.putAll(headers);
        }
        this.initRestTemplate();
    }

    private void initRestTemplate() {
        boolean isContainsConverter = false;
        for (HttpMessageConverter httpMessageConverter : this.restTemplate.getMessageConverters()) {
            if (!MappingJacksonRPC2HttpMessageConverter.class.isAssignableFrom(httpMessageConverter.getClass())) continue;
            isContainsConverter = true;
            break;
        }
        if (!isContainsConverter) {
            MappingJacksonRPC2HttpMessageConverter messageConverter = new MappingJacksonRPC2HttpMessageConverter();
            messageConverter.setObjectMapper(this.getObjectMapper());
            ArrayList<MappingJacksonRPC2HttpMessageConverter> restMessageConverters = new ArrayList<MappingJacksonRPC2HttpMessageConverter>();
            restMessageConverters.addAll(this.restTemplate.getMessageConverters());
            restMessageConverters.add(0, messageConverter);
            this.restTemplate.setMessageConverters(restMessageConverters);
        }
        if (this.restTemplate.getErrorHandler() instanceof DefaultResponseErrorHandler) {
            this.restTemplate.setErrorHandler((ResponseErrorHandler)JsonRpcResponseErrorHandler.INSTANCE);
        }
    }

    public JsonRpcRestClient(URL serviceUrl, Map<String, String> headers) {
        this(serviceUrl, new ObjectMapper(), headers);
    }

    private JsonRpcRestClient(URL serviceUrl, ObjectMapper mapper, Map<String, String> headers) {
        this(serviceUrl, mapper, null, headers);
    }

    public JsonRpcRestClient(URL serviceUrl, RestTemplate restTemplate) {
        this(serviceUrl, new ObjectMapper(), restTemplate, null);
    }

    public void setConnectionProxy(Proxy connectionProxy) {
        this.getRequestFactory().setProxy(connectionProxy);
    }

    private SslClientHttpRequestFactory getRequestFactory() {
        if (this.requestFactory == null) {
            throw new IllegalStateException("Used external RequestTemplate instance");
        }
        return this.requestFactory;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.getRequestFactory().setConnectTimeout(connectionTimeoutMillis);
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.getRequestFactory().setReadTimeout(readTimeoutMillis);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public void setSslContext(SSLContext sslContext) {
        if (sslContext != null) {
            this.getRequestFactory().setSslContext(sslContext);
        }
    }

    public void setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        if (hostNameVerifier != null) {
            this.getRequestFactory().setHostNameVerifier(hostNameVerifier);
        }
    }

    public URL getServiceUrl() {
        return this.serviceUrl.get();
    }

    public void setServiceUrl(URL serviceUrl) {
        this.serviceUrl.set(serviceUrl);
    }

    @Override
    public void invoke(String methodName, Object argument) throws Throwable {
        this.invoke(methodName, argument, null, new HashMap<String, String>());
    }

    @Override
    public Object invoke(String methodName, Object argument, Type returnType) throws Throwable {
        return this.invoke(methodName, argument, returnType, new HashMap<String, String>());
    }

    @Override
    public Object invoke(String methodName, Object argument, Type returnType, Map<String, String> extraHeaders) throws Throwable {
        JsonNode response;
        ObjectNode request = super.createRequest(methodName, argument);
        LinkedMultiValueMap httpHeaders = new LinkedMultiValueMap();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpHeaders.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        if (extraHeaders != null) {
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                httpHeaders.add((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        HttpEntity requestHttpEntity = new HttpEntity((Object)request, (MultiValueMap)httpHeaders);
        try {
            response = (JsonNode)this.restTemplate.postForObject(this.serviceUrl.get().toExternalForm(), (Object)requestHttpEntity, ObjectNode.class, new Object[0]);
        }
        catch (HttpStatusCodeException httpStatusCodeException) {
            this.logger.error("HTTP Error code={} status={}\nresponse={}", new Object[]{httpStatusCodeException.getStatusCode().value(), httpStatusCodeException.getStatusText(), httpStatusCodeException.getResponseBodyAsString()});
            Integer jsonErrorCode = DefaultHttpStatusCodeProvider.INSTANCE.getJsonRpcCode(httpStatusCodeException.getStatusCode().value());
            if (jsonErrorCode == null) {
                jsonErrorCode = httpStatusCodeException.getStatusCode().value();
            }
            throw new JsonRpcClientException(jsonErrorCode, httpStatusCodeException.getStatusText(), null);
        }
        catch (HttpMessageConversionException httpMessageConversionException) {
            this.logger.error("Can not convert (request/response)", (Throwable)httpMessageConversionException);
            throw new JsonRpcClientException(0, "Invalid JSON-RPC response", null);
        }
        return this.readResponse(returnType, response);
    }

    @Override
    public <T> T invoke(String methodName, Object argument, Class<T> clazz) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz));
    }

    @Override
    public <T> T invoke(String methodName, Object argument, Class<T> clazz, Map<String, String> extraHeaders) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz), extraHeaders);
    }
}

