/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring.rest;

import com.googlecode.jsonrpc4j.spring.rest.MappingJacksonRPC2HttpMessageConverter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class JsonRpcResponseErrorHandler
implements ResponseErrorHandler {
    public static final JsonRpcResponseErrorHandler INSTANCE = new JsonRpcResponseErrorHandler();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<Integer> JSON_RPC_STATUES = new HashSet<Integer>();

    private JsonRpcResponseErrorHandler() {
        this.JSON_RPC_STATUES.add(500);
        this.JSON_RPC_STATUES.add(400);
        this.JSON_RPC_STATUES.add(404);
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        MediaType contentType;
        HttpStatus httpStatus = this.getHttpStatusCode(response);
        if (this.JSON_RPC_STATUES.contains(httpStatus.value()) && MappingJacksonRPC2HttpMessageConverter.APPLICATION_JSON_RPC.isCompatibleWith(contentType = response.getHeaders().getContentType())) {
            return false;
        }
        return httpStatus.series() == HttpStatus.Series.CLIENT_ERROR || httpStatus.series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = this.getHttpStatusCode(response);
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw new HttpClientErrorException(statusCode, response.getStatusText(), response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
            }
            case SERVER_ERROR: {
                throw new HttpServerErrorException(statusCode, response.getStatusText(), response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
            }
        }
        throw new RestClientException("Unknown status code [" + statusCode + "]");
    }

    private HttpStatus getHttpStatusCode(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode;
        try {
            statusCode = response.getStatusCode();
        }
        catch (IllegalArgumentException ex) {
            throw new UnknownHttpStatusCodeException(response.getRawStatusCode(), response.getStatusText(), response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
        }
        return statusCode;
    }

    private byte[] getResponseBody(ClientHttpResponse response) {
        try {
            InputStream responseBody = response.getBody();
            if (responseBody != null) {
                return FileCopyUtils.copyToByteArray((InputStream)responseBody);
            }
        }
        catch (IOException ex) {
            this.logger.debug("Can not read resonse body", (Throwable)ex);
        }
        return new byte[0];
    }

    private Charset getCharset(ClientHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType.getCharset() : null;
    }
}

