/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ConvertedParameterTransformer;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.HttpStatusCodeProvider;
import com.googlecode.jsonrpc4j.InvocationListener;
import com.googlecode.jsonrpc4j.JsonRpcInterceptor;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import java.util.List;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.RemoteExporter;

abstract class AbstractJsonServiceExporter
extends RemoteExporter
implements InitializingBean,
ApplicationContextAware {
    private ObjectMapper objectMapper;
    private JsonRpcServer jsonRpcServer;
    private ApplicationContext applicationContext;
    private ErrorResolver errorResolver = null;
    private boolean backwardsCompatible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private boolean shouldLogInvocationErrors = true;
    private InvocationListener invocationListener = null;
    private HttpStatusCodeProvider httpStatusCodeProvider = null;
    private ConvertedParameterTransformer convertedParameterTransformer = null;
    private String contentType = null;
    private List<JsonRpcInterceptor> interceptorList;

    AbstractJsonServiceExporter() {
    }

    public void afterPropertiesSet() throws Exception {
        if (this.objectMapper == null && this.applicationContext != null && this.applicationContext.containsBean("objectMapper")) {
            this.objectMapper = (ObjectMapper)this.applicationContext.getBean("objectMapper");
        }
        if (this.objectMapper == null && this.applicationContext != null) {
            try {
                this.objectMapper = (ObjectMapper)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ObjectMapper.class);
            }
            catch (Exception e) {
                this.logger.debug((Object)e);
            }
        }
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        this.jsonRpcServer = new JsonRpcServer(this.objectMapper, null == this.getServiceInterface() ? this.getService() : this.getProxyForService(), this.getServiceInterface());
        this.jsonRpcServer.setErrorResolver(this.errorResolver);
        this.jsonRpcServer.setBackwardsCompatible(this.backwardsCompatible);
        this.jsonRpcServer.setRethrowExceptions(this.rethrowExceptions);
        this.jsonRpcServer.setAllowExtraParams(this.allowExtraParams);
        this.jsonRpcServer.setAllowLessParams(this.allowLessParams);
        this.jsonRpcServer.setInvocationListener(this.invocationListener);
        this.jsonRpcServer.setHttpStatusCodeProvider(this.httpStatusCodeProvider);
        this.jsonRpcServer.setConvertedParameterTransformer(this.convertedParameterTransformer);
        this.jsonRpcServer.setShouldLogInvocationErrors(this.shouldLogInvocationErrors);
        if (this.contentType != null) {
            this.jsonRpcServer.setContentType(this.contentType);
        }
        if (this.interceptorList != null) {
            this.jsonRpcServer.setInterceptorList(this.interceptorList);
        }
        ReflectionUtil.clearCache();
        this.exportService();
    }

    void exportService() throws Exception {
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    JsonRpcServer getJsonRpcServer() {
        return this.jsonRpcServer;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setBackwardsCompatible(boolean backwardsCompatible) {
        this.backwardsCompatible = backwardsCompatible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }

    public void setHttpStatusCodeProvider(HttpStatusCodeProvider httpStatusCodeProvider) {
        this.httpStatusCodeProvider = httpStatusCodeProvider;
    }

    public void setConvertedParameterTransformer(ConvertedParameterTransformer convertedParameterTransformer) {
        this.convertedParameterTransformer = convertedParameterTransformer;
    }

    public void setShouldLogInvocationErrors(boolean shouldLogInvocationErrors) {
        this.shouldLogInvocationErrors = shouldLogInvocationErrors;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setInterceptorList(List<JsonRpcInterceptor> interceptorList) {
        this.interceptorList = interceptorList;
    }
}

