/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.googlecode.jsonrpc4j.JsonRpcMethod;
import com.googlecode.jsonrpc4j.JsonRpcParam;
import com.googlecode.jsonrpc4j.JsonRpcParamsPassMode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ReflectionUtil {
    private static final Map<String, Set<Method>> methodCache = new ConcurrentHashMap<String, Set<Method>>();
    private static final Map<Method, List<Class<?>>> parameterTypeCache = new ConcurrentHashMap();
    private static final Map<Method, List<Annotation>> methodAnnotationCache = new ConcurrentHashMap<Method, List<Annotation>>();
    private static final Map<Method, List<List<Annotation>>> methodParamAnnotationCache = new ConcurrentHashMap<Method, List<List<Annotation>>>();

    static Set<Method> findCandidateMethods(Class<?>[] classes, String name) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> clazz : classes) {
            sb.append(clazz.getName()).append("::");
        }
        String cacheKey = sb.append(name).toString();
        if (methodCache.containsKey(cacheKey)) {
            return methodCache.get(cacheKey);
        }
        HashSet<Method> methods = new HashSet();
        for (Class<?> clazz : classes) {
            for (Method method : clazz.getMethods()) {
                if (method.isAnnotationPresent(JsonRpcMethod.class)) {
                    JsonRpcMethod methodAnnotation = method.getAnnotation(JsonRpcMethod.class);
                    if (methodAnnotation.required()) {
                        if (!methodAnnotation.value().equals(name)) continue;
                        methods.add(method);
                        continue;
                    }
                    if (!methodAnnotation.value().equals(name) && !method.getName().equals(name)) continue;
                    methods.add(method);
                    continue;
                }
                if (!method.getName().equals(name)) continue;
                methods.add(method);
            }
        }
        methods = Collections.unmodifiableSet(methods);
        methodCache.put(cacheKey, methods);
        return methods;
    }

    static List<Class<?>> getParameterTypes(Method method) {
        if (parameterTypeCache.containsKey(method)) {
            return parameterTypeCache.get(method);
        }
        ArrayList<Class<?>> types = new ArrayList();
        Collections.addAll(types, method.getParameterTypes());
        types = Collections.unmodifiableList(types);
        parameterTypeCache.put(method, types);
        return types;
    }

    public static <T extends Annotation> List<T> getAnnotations(Method method, Class<T> type) {
        return ReflectionUtil.filterAnnotations(ReflectionUtil.getAnnotations(method), type);
    }

    private static <T extends Annotation> List<T> filterAnnotations(Collection<Annotation> annotations, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Annotation annotation : annotations) {
            if (!type.isInstance(annotation)) continue;
            result.add(type.cast(annotation));
        }
        return result;
    }

    private static List<Annotation> getAnnotations(Method method) {
        if (methodAnnotationCache.containsKey(method)) {
            return methodAnnotationCache.get(method);
        }
        ArrayList<Annotation> annotations = new ArrayList();
        Collections.addAll(annotations, method.getAnnotations());
        annotations = Collections.unmodifiableList(annotations);
        methodAnnotationCache.put(method, annotations);
        return annotations;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> type) {
        for (Annotation a : ReflectionUtil.getAnnotations(method)) {
            if (!type.isInstance(a)) continue;
            return (T)((Annotation)type.cast(a));
        }
        return null;
    }

    static <T extends Annotation> List<List<T>> getParameterAnnotations(Method method, Class<T> type) {
        ArrayList<List<T>> annotations = new ArrayList<List<T>>();
        for (List<Annotation> paramAnnotations : ReflectionUtil.getParameterAnnotations(method)) {
            annotations.add(ReflectionUtil.filterAnnotations(paramAnnotations, type));
        }
        return annotations;
    }

    private static List<List<Annotation>> getParameterAnnotations(Method method) {
        if (methodParamAnnotationCache.containsKey(method)) {
            return methodParamAnnotationCache.get(method);
        }
        ArrayList<List<Annotation>> annotations = new ArrayList();
        for (Annotation[] paramAnnotations : method.getParameterAnnotations()) {
            ArrayList listAnnotations = new ArrayList();
            Collections.addAll(listAnnotations, paramAnnotations);
            annotations.add(listAnnotations);
        }
        annotations = Collections.unmodifiableList(annotations);
        methodParamAnnotationCache.put(method, annotations);
        return annotations;
    }

    public static Object parseArguments(Method method, Object[] arguments) {
        JsonRpcParamsPassMode paramsPassMode = JsonRpcParamsPassMode.AUTO;
        JsonRpcMethod jsonRpcMethod = ReflectionUtil.getAnnotation(method, JsonRpcMethod.class);
        if (jsonRpcMethod != null) {
            paramsPassMode = jsonRpcMethod.paramsPassMode();
        }
        Map<String, Object> namedParams = ReflectionUtil.getNamedParameters(method, arguments);
        switch (paramsPassMode) {
            case ARRAY: {
                if (namedParams.size() > 0) {
                    Object[] parsed = new Object[namedParams.size()];
                    int i = 0;
                    for (Object value : namedParams.values()) {
                        parsed[i++] = value;
                    }
                    return parsed;
                }
                return arguments != null ? arguments : new Object[]{};
            }
            case OBJECT: {
                if (namedParams.size() > 0) {
                    return namedParams;
                }
                if (arguments == null) {
                    return new Object[0];
                }
                throw new IllegalArgumentException("OBJECT parameters pass mode is impossible without declaring JsonRpcParam annotations for all parameters on method " + method.getName());
            }
        }
        if (namedParams.size() > 0) {
            return namedParams;
        }
        return arguments != null ? arguments : new Object[]{};
    }

    private static Map<String, Object> getNamedParameters(Method method, Object[] arguments) {
        LinkedHashMap<String, Object> namedParams = new LinkedHashMap<String, Object>();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        block0: for (int i = 0; i < paramAnnotations.length; ++i) {
            Annotation[] ann;
            for (Annotation an : ann = paramAnnotations[i]) {
                if (!JsonRpcParam.class.isInstance(an)) continue;
                JsonRpcParam jAnn = (JsonRpcParam)an;
                namedParams.put(jAnn.value(), arguments[i]);
                continue block0;
            }
        }
        if (arguments != null && arguments.length > 0 && namedParams.size() > 0 && namedParams.size() != arguments.length) {
            throw new IllegalArgumentException("JsonRpcParam annotations were not found for all parameters on method " + method.getName());
        }
        return namedParams;
    }

    public static void clearCache() {
        methodCache.clear();
        parameterTypeCache.clear();
        methodAnnotationCache.clear();
        methodParamAnnotationCache.clear();
    }
}

