/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcMultiServer
extends JsonRpcServer {
    public static final char DEFAULT_SEPARATOR = '.';
    private static final Logger logger = LoggerFactory.getLogger(JsonRpcMultiServer.class);
    private final Map<String, Object> handlerMap;
    private final Map<String, Class<?>> interfaceMap;
    private char separator = (char)46;

    public JsonRpcMultiServer() {
        this(new ObjectMapper());
        logger.debug("created empty multi server");
    }

    public JsonRpcMultiServer(ObjectMapper mapper) {
        super(mapper, (Object)null);
        this.handlerMap = new HashMap<String, Object>();
        this.interfaceMap = new HashMap();
    }

    public JsonRpcMultiServer addService(String name, Object handler) {
        return this.addService(name, handler, null);
    }

    public JsonRpcMultiServer addService(String name, Object handler, Class<?> remoteInterface) {
        logger.debug("add service interface {} with handler {}", remoteInterface, handler);
        this.handlerMap.put(name, handler);
        if (remoteInterface != null) {
            this.interfaceMap.put(name, remoteInterface);
        }
        return this;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    @Override
    protected Class<?>[] getHandlerInterfaces(String serviceName) {
        Class<?> remoteInterface = this.interfaceMap.get(serviceName);
        if (remoteInterface != null) {
            return new Class[]{remoteInterface};
        }
        if (Proxy.isProxyClass(this.getHandler(serviceName).getClass())) {
            return this.getHandler(serviceName).getClass().getInterfaces();
        }
        return new Class[]{this.getHandler(serviceName).getClass()};
    }

    @Override
    protected String getServiceName(String methodName) {
        int ndx;
        if (methodName != null && (ndx = methodName.indexOf(this.separator)) > 0) {
            return methodName.substring(0, ndx);
        }
        return methodName;
    }

    @Override
    protected String getMethodName(String methodName) {
        int ndx;
        if (methodName != null && (ndx = methodName.indexOf(this.separator)) > 0) {
            return methodName.substring(ndx + 1);
        }
        return methodName;
    }

    @Override
    protected Object getHandler(String serviceName) {
        Object handler = this.handlerMap.get(serviceName);
        if (handler == null) {
            logger.error("Service '{}' is not registered in this multi-server", (Object)serviceName);
            throw new RuntimeException("Service '" + serviceName + "' does not exist");
        }
        return handler;
    }
}

