/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class JsonRpcHttpClient
extends JsonRpcClient
implements IJsonRpcClient {
    private static final String GZIP = "gzip";
    private final Map<String, String> headers = new HashMap<String, String>();
    private URL serviceUrl;
    private Proxy connectionProxy = Proxy.NO_PROXY;
    private int connectionTimeoutMillis = 60000;
    private int readTimeoutMillis = 120000;
    private SSLContext sslContext = null;
    private HostnameVerifier hostNameVerifier = null;
    private String contentType = "application/json-rpc";
    private boolean gzipRequests = false;

    public JsonRpcHttpClient(URL serviceUrl, Map<String, String> headers) {
        this(new ObjectMapper(), serviceUrl, headers);
    }

    public JsonRpcHttpClient(ObjectMapper mapper, URL serviceUrl, Map<String, String> headers) {
        this(mapper, serviceUrl, headers, false, false);
    }

    public JsonRpcHttpClient(ObjectMapper mapper, URL serviceUrl, Map<String, String> headers, boolean gzipRequests, boolean acceptGzipResponses) {
        super(mapper);
        this.serviceUrl = serviceUrl;
        this.headers.putAll(headers);
        this.gzipRequests = gzipRequests;
        if (acceptGzipResponses) {
            this.headers.put("Accept-Encoding", GZIP);
        }
    }

    public JsonRpcHttpClient(URL serviceUrl) {
        this(new ObjectMapper(), serviceUrl, new HashMap<String, String>());
    }

    @Override
    public void invoke(String methodName, Object argument) throws Throwable {
        this.invoke(methodName, argument, null, new HashMap<String, String>());
    }

    @Override
    public Object invoke(String methodName, Object argument, Type returnType) throws Throwable {
        return this.invoke(methodName, argument, returnType, new HashMap<String, String>());
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object invoke(String methodName, Object argument, Type returnType, Map<String, String> extraHeaders) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T> T invoke(String methodName, Object argument, Class<T> clazz) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz));
    }

    @Override
    public <T> T invoke(String methodName, Object argument, Class<T> clazz, Map<String, String> extraHeaders) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz), extraHeaders);
    }

    private HttpURLConnection prepareConnection(Map<String, String> extraHeaders) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.serviceUrl.openConnection(this.connectionProxy);
        connection.setConnectTimeout(this.connectionTimeoutMillis);
        connection.setReadTimeout(this.readTimeoutMillis);
        connection.setAllowUserInteraction(false);
        connection.setDefaultUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestMethod("POST");
        this.setupSsl(connection);
        this.addHeaders(extraHeaders, connection);
        return connection;
    }

    private boolean useGzip(HttpURLConnection connection) {
        String contentEncoding = connection.getHeaderField("Content-Encoding");
        return contentEncoding != null && contentEncoding.equalsIgnoreCase(GZIP);
    }

    private InputStream getStream(InputStream inputStream, boolean useGzip) throws IOException {
        return useGzip ? new GZIPInputStream(inputStream) : inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readErrorString(HttpURLConnection connection) {
        try (InputStream stream = connection.getErrorStream();){
            StringBuilder buffer = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));){
                int ch = reader.read();
                while (ch >= 0) {
                    buffer.append((char)ch);
                    ch = reader.read();
                }
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private void setupSsl(HttpURLConnection connection) {
        if (HttpsURLConnection.class.isInstance(connection)) {
            HttpsURLConnection https = (HttpsURLConnection)HttpsURLConnection.class.cast(connection);
            if (this.hostNameVerifier != null) {
                https.setHostnameVerifier(this.hostNameVerifier);
            }
            if (this.sslContext != null) {
                https.setSSLSocketFactory(this.sslContext.getSocketFactory());
            }
        }
    }

    private void addHeaders(Map<String, String> extraHeaders, HttpURLConnection connection) {
        connection.setRequestProperty("Content-Type", this.contentType);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(URL serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public void setConnectionProxy(Proxy connectionProxy) {
        this.connectionProxy = connectionProxy;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.hostNameVerifier = hostNameVerifier;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

