/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.utils;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedBytes;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.CaseUtils;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.types.codec.Compact;
import org.polkadot.types.codec.Option;
import org.polkadot.types.codec.U8a;
import org.polkadot.types.type.Event;
import org.polkadot.types.type.ExtrinsicSignature;

public class Utils {
    static final String HEX_REGEX = "^0x[a-fA-F0-9]+$";
    static String UNPREFIX_HEX_REGEX = "^[a-fA-F0-9]+$";
    static final String ZERO_STR = "0x00";
    static final String ALPHABET = "0123456789abcdef";
    static final BigInteger MAX_U8 = BigInteger.valueOf(2L).pow(6).subtract(BigInteger.ONE);
    static final BigInteger MAX_U16 = BigInteger.valueOf(2L).pow(14).subtract(BigInteger.ONE);
    static final BigInteger MAX_U32 = BigInteger.valueOf(2L).pow(30).subtract(BigInteger.ONE);

    public static boolean isHex(Object value) {
        return Utils.isHex(value, -1, false);
    }

    public static boolean isHex(Object value, int bitLength, boolean ignoreLength) {
        boolean isValidHex;
        if (value == null) {
            return false;
        }
        boolean bl = isValidHex = value.equals("0x") || value instanceof String && Pattern.matches(HEX_REGEX, (CharSequence)value);
        if (isValidHex && bitLength != -1) {
            String strValue = (String)value;
            return strValue.length() == 2 + (int)Math.ceil(bitLength / 4);
        }
        return isValidHex && (ignoreLength || ((String)value).length() % 2 == 0);
    }

    public static byte[] hexToU8a(String value, int bitLength) {
        if (value == null) {
            return new byte[0];
        }
        assert (Utils.isHex(value)) : "Expected hex value to convert, found " + value;
        value = Utils.hexStripPrefix(value);
        int valLength = value.length() / 2;
        int bufLength = (int)Math.ceil(bitLength == -1 ? (float)valLength : (float)bitLength / 8.0f);
        byte[] result = new byte[bufLength];
        int offSet = Math.max(0, bufLength - valLength);
        for (int index = 0; index < bufLength; ++index) {
            String byteStr = value.substring(index * 2, index * 2 + 2);
            result[index + offSet] = UnsignedBytes.parseUnsignedByte((String)byteStr, (int)16);
        }
        return result;
    }

    public static byte[] hexToU8a(String value) {
        return Utils.hexToU8a(value, -1);
    }

    public static String hexStripPrefix(String value) {
        if (value == null) {
            return "";
        }
        if (Utils.hexHasPrefix(value)) {
            return value.substring(2);
        }
        if (Pattern.matches(UNPREFIX_HEX_REGEX, value)) {
            return value;
        }
        throw new RuntimeException("Invalid hex " + value + " passed to hexStripPrefix");
    }

    public static boolean hexHasPrefix(String value) {
        return value != null && Utils.isHex(value, -1, true) && value.substring(0, 2).equals("0x");
    }

    public static boolean isU8a(Object value) {
        return value instanceof byte[] || value instanceof U8a;
    }

    public static BigInteger hexToBn(Object value, boolean isLe, boolean isNegative) {
        if (value == null) {
            return BigInteger.ZERO;
        }
        String rawValue = Utils.hexStripPrefix((String)value);
        if (isLe) {
            StringBuilder reverse = new StringBuilder(rawValue).reverse();
            for (int i = 0; i < reverse.length(); i += 2) {
                char c1 = reverse.charAt(i);
                char c2 = reverse.charAt(i + 1);
                reverse.setCharAt(i + 1, c1);
                reverse.setCharAt(i, c2);
            }
            rawValue = reverse.toString();
        }
        BigInteger bigInteger = BigInteger.ZERO;
        if (rawValue.length() > 0) {
            bigInteger = new BigInteger(rawValue, 16);
        }
        if (isNegative) {
            throw new UnsupportedOperationException();
        }
        return bigInteger;
    }

    public static BigInteger u8aToBn(byte[] value, boolean isLe, boolean isNegative) {
        return Utils.hexToBn(Utils.u8aToHex(value), isLe, isNegative);
    }

    public static BigInteger bnToBn(Object value) {
        if (value == null) {
            return BigInteger.ZERO;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            return new BigInteger(value.toString());
        }
        if (value instanceof String) {
            return new BigInteger((String)value, 16);
        }
        throw new RuntimeException(" bnToBn " + value);
    }

    public static String bnToHex(BigInteger value, int bitLength) {
        return Utils.bnToHex(value, false, false, bitLength);
    }

    public static String bnToHex(BigInteger value, boolean isLe, boolean isNegtive, int bitLength) {
        if (value == null) {
            return ZERO_STR;
        }
        return Utils.u8aToHex(Utils.bnToU8a(value, isLe, isNegtive, bitLength));
    }

    public static byte[] bnToU8a(BigInteger value, boolean isLe, int bitLength) {
        return Utils.bnToU8a(value, isLe, false, bitLength);
    }

    public static byte[] bnToU8a(BigInteger value, boolean isLe, boolean isNegative, int bitLength) {
        BigInteger valueBn = Utils.bnToBn(value);
        int byteLength = bitLength == -1 ? (int)Math.ceil((float)valueBn.bitLength() / 8.0f) : (int)Math.ceil((float)bitLength / 8.0f);
        if (value == null) {
            if (bitLength == -1) {
                return new byte[0];
            }
            return new byte[byteLength];
        }
        byte[] output = new byte[byteLength];
        if (isNegative) {
            // empty if block
        }
        if (isLe) {
            byte[] bytes = Utils.toByteArrayLittleEndianUnsigned(valueBn);
            System.arraycopy(bytes, 0, output, 0, bytes.length);
        } else {
            byte[] bytes = valueBn.toByteArray();
            System.arraycopy(bytes, 0, output, output.length - bytes.length, bytes.length);
        }
        return output;
    }

    public static void main(String[] argv) {
        System.out.println(System.currentTimeMillis());
        BigInteger bi = BigInteger.valueOf(1557849267933L);
        System.out.println(Arrays.toString(bi.toByteArray()));
        System.out.println(Arrays.toString(Utils.toByteArrayLittleEndianUnsigned(bi)));
        System.out.println(Arrays.toString(Utils.bnToU8a(bi, false, true, 64)));
        System.out.println(Arrays.toString(Utils.bnToU8a(bi, true, true, 64)));
    }

    public static byte[] toByteArrayLittleEndianUnsigned(BigInteger bi) {
        byte[] extractedBytes = Utils.toByteArrayUnsigned(bi);
        ArrayUtils.reverse((byte[])extractedBytes);
        return extractedBytes;
    }

    public static byte[] toByteArrayUnsigned(BigInteger bi) {
        byte[] extractedBytes = bi.toByteArray();
        int skipped = 0;
        boolean skip = true;
        for (byte b : extractedBytes) {
            boolean signByte;
            boolean bl = signByte = b == 0;
            if (skip && signByte) {
                ++skipped;
                continue;
            }
            if (!skip) continue;
            skip = false;
        }
        extractedBytes = Arrays.copyOfRange(extractedBytes, skipped, extractedBytes.length);
        return extractedBytes;
    }

    public static Pair<Integer, BigInteger> compactFromU8a(Object _input, int bitLength) {
        byte[] input = Utils.u8aToU8a(_input);
        if (input.length == 0) {
            return Pair.of((Object)1, (Object)new BigInteger("0").shiftRight(2));
        }
        int flag = UnsignedBytes.toInt((byte)input[0]) & 3;
        if (flag == 0) {
            return Pair.of((Object)1, (Object)new BigInteger(UnsignedBytes.toInt((byte)input[0]) + "").shiftRight(2));
        }
        if (flag == 1) {
            byte[] subarray = ArrayUtils.subarray((byte[])input, (int)0, (int)2);
            return Pair.of((Object)2, (Object)Utils.u8aToBn(subarray, true, false).shiftRight(2));
        }
        if (flag == 2) {
            byte[] subarray = ArrayUtils.subarray((byte[])input, (int)0, (int)4);
            return Pair.of((Object)4, (Object)Utils.u8aToBn(subarray, true, false).shiftRight(2));
        }
        int length = BigInteger.valueOf(UnsignedBytes.toInt((byte)input[0])).shiftRight(2).add(BigInteger.valueOf(4L)).intValue();
        int offset = length + 1;
        return Pair.of((Object)offset, (Object)Utils.u8aToBn(ArrayUtils.subarray((byte[])input, (int)1, (int)offset), true, false));
    }

    public static Pair<Integer, BigInteger> compactFromU8a(Object input) {
        return Utils.compactFromU8a(input, 32);
    }

    public static String u8aToString(byte[] value) {
        if (value == null || value.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : value) {
            char ch = (char)UnsignedBytes.toInt((byte)b);
            sb.append(ch);
        }
        return new String(value);
    }

    public static String u8aToHex(byte[] value, int bitLength, boolean isPrefixed) {
        String prefix;
        String string = prefix = isPrefixed ? "0x" : "";
        if (ArrayUtils.isEmpty((byte[])value)) {
            return prefix;
        }
        int byteLength = (int)Math.ceil((float)bitLength / 8.0f);
        if (byteLength > 0 && value.length > byteLength) {
            int halfLength = (int)Math.ceil((float)byteLength / 2.0f);
            String left = Utils.u8aToHex(ArrayUtils.subarray((byte[])value, (int)0, (int)halfLength), -1, isPrefixed);
            String right = Utils.u8aToHex(ArrayUtils.subarray((byte[])value, (int)(value.length - halfLength), (int)value.length), -1, false);
            return left + "..." + right;
        }
        StringBuilder stringBuilder = new StringBuilder(prefix);
        for (byte b : value) {
            int ub = UnsignedBytes.toInt((byte)b);
            stringBuilder.append(ALPHABET.charAt(ub >> 4)).append(ALPHABET.charAt(ub & 0xF));
        }
        return stringBuilder.toString();
    }

    public static String u8aToHex(byte[] value) {
        return Utils.u8aToHex(value, -1, true);
    }

    public static byte[] stringToU8a(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return new byte[0];
        }
        return value.getBytes();
    }

    public static byte[] compactAddLength(byte[] input) {
        return Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{Utils.compactToU8a(input.length), input}));
    }

    public static byte[] compactToU8a(Object _value) {
        BigInteger value = Utils.bnToBn(_value);
        if (value.compareTo(MAX_U8) <= 0) {
            return new byte[]{UnsignedBytes.parseUnsignedByte((String)((value.intValue() << 2) + ""))};
        }
        if (value.compareTo(MAX_U16) <= 0) {
            return Utils.bnToU8a(value.shiftLeft(2).add(BigInteger.valueOf(1L)), true, false, 16);
        }
        if (value.compareTo(MAX_U32) <= 0) {
            return Utils.bnToU8a(value.shiftLeft(2).add(BigInteger.valueOf(2L)), true, false, 32);
        }
        byte[] u8a = Utils.bnToU8a(value, true, false, -1);
        int length = u8a.length;
        while (u8a[length - 1] == 0) {
            --length;
        }
        assert (length >= 4) : "Previous tests match anyting less than 2^30; qed";
        return Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{{UnsignedBytes.parseUnsignedByte((String)((length - 4 << 2) + 3 + ""))}, ArrayUtils.subarray((byte[])u8a, (int)0, (int)length)}));
    }

    public static byte[] u8aConcat(List<byte[]> _list) {
        List list = _list.stream().map(e -> Utils.u8aToU8a(e)).collect(Collectors.toList());
        int length = list.stream().mapToInt(e -> ((byte[])e).length).sum();
        byte[] result = new byte[length];
        int offset = 0;
        for (byte[] bytes : list) {
            System.arraycopy(bytes, 0, result, offset, bytes.length);
            offset += bytes.length;
        }
        return result;
    }

    public static byte[] u8aToU8a(Object value) {
        if (value == null) {
            return new byte[0];
        }
        if (value instanceof String) {
            String strValue = (String)value;
            return Utils.isHex(strValue) ? Utils.hexToU8a(strValue) : Utils.stringToU8a(strValue);
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof U8a) {
            return ((U8a)value).raw;
        }
        if (value.getClass().isArray()) {
            List<Object> objects = CodecUtils.arrayLikeToList(value);
            byte[] result = new byte[objects.size()];
            for (int i = 0; i < objects.size(); ++i) {
                Number number = (Number)objects.get(i);
                result[i] = UnsignedBytes.parseUnsignedByte((String)number.toString());
            }
            return result;
        }
        return (byte[])value;
    }

    public static String stringLowerFirst(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static boolean isContainer(Object object) {
        if (object instanceof ExtrinsicSignature) {
            return false;
        }
        if (object instanceof Event) {
            return false;
        }
        if (object instanceof Collection || object instanceof Map) {
            return true;
        }
        if (object instanceof Option || object instanceof Compact) {
            return true;
        }
        if (object.getClass().isArray()) {
            Class<?> componentType = object.getClass().getComponentType();
            return !componentType.isPrimitive();
        }
        return false;
    }

    public static BigInteger toBn(Object value) {
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        return new BigInteger(value.toString());
    }

    public static String stringCamelCase(String input) {
        return CaseUtils.toCamelCase((String)input, (boolean)false, (char[])new char[]{'-', '_', ' '});
    }

    public static byte[] u8aFixLength(byte[] value, int bitLength, boolean atStart) {
        int byteLength = (int)Math.ceil((float)bitLength / 8.0f);
        if (bitLength == -1 || value.length == byteLength) {
            return value;
        }
        if (value.length > byteLength) {
            return ArrayUtils.subarray((byte[])value, (int)0, (int)byteLength);
        }
        byte[] result = new byte[byteLength];
        if (atStart) {
            System.arraycopy(value, 0, result, 0, value.length);
        } else {
            System.arraycopy(value, 0, result, byteLength - value.length, value.length);
        }
        return result;
    }

    public static boolean u8aStrEq(byte[] u8a1, byte[] u8a2) {
        return u8a1 != null && u8a2 != null && Arrays.toString(u8a1).equals(Arrays.toString(u8a2));
    }

    public static byte[] randomAsU8a() {
        return Utils.randomAsU8a(32);
    }

    public static byte[] randomAsU8a(int length) {
        throw new UnsupportedOperationException();
    }

    public static Pair<Integer, byte[]> compactStripLength(byte[] input, int bitLength) {
        Pair<Integer, BigInteger> pair = Utils.compactFromU8a(input, bitLength);
        Integer offset = (Integer)pair.getLeft();
        int length = ((BigInteger)pair.getRight()).intValue();
        int total = offset + length;
        return Pair.of((Object)total, (Object)ArrayUtils.subarray((byte[])input, (int)offset, (int)total));
    }

    public static Pair<Integer, byte[]> compactStripLength(byte[] input) {
        return Utils.compactStripLength(input, 32);
    }

    public static String toU8aString(byte[] bytes) {
        int[] ints = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ints[i] = UnsignedBytes.toInt((byte)bytes[i]);
        }
        return Arrays.toString(ints);
    }
}

