/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.type;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.polkadot.common.keyring.Types;
import org.polkadot.types.Types;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.primitive.Method;
import org.polkadot.types.primitive.U8;
import org.polkadot.types.rpc.RuntimeVersion;
import org.polkadot.types.type.Address;
import org.polkadot.types.type.ExtrinsicEra;
import org.polkadot.types.type.NonceCompact;
import org.polkadot.types.type.Signature;
import org.polkadot.types.type.SignaturePayload;
import org.polkadot.utils.Utils;

public class ExtrinsicSignature
extends Struct
implements Types.IExtrinsicSignature {
    public static final byte[] IMMORTAL_ERA = new byte[]{0};
    public static final int BIT_SIGNED = 128;
    public static final int BIT_UNSIGNED = 0;
    public static final int BIT_VERSION = 1;

    public ExtrinsicSignature(Object value) {
        super(new Types.ConstructorDef().add("version", U8.class).add("signer", Address.class).add("signature", Signature.class).add("nonce", NonceCompact.class).add("era", ExtrinsicEra.class), ExtrinsicSignature.decodeExtrinsicSignature(value));
    }

    static Object decodeExtrinsicSignature(Object _value) {
        HashMap<String, Byte> ret = new HashMap<String, Byte>();
        if (_value == null) {
            ret.put("version", (byte)1);
            return ret;
        }
        byte[] value = Utils.u8aToU8a(_value);
        if (value == null) {
            ret.put("version", (byte)1);
            return ret;
        }
        byte version = value[0];
        ret.put("version", version);
        return (version & 0x80) == 128 ? value : (byte[])ret;
    }

    @Override
    public int getEncodedLength() {
        return this.isSigned() ? super.getEncodedLength() : 1;
    }

    @Override
    public boolean isSigned() {
        return (this.version() & 0x80) == 128;
    }

    public ExtrinsicEra getEra() {
        return (ExtrinsicEra)this.getField("era");
    }

    public NonceCompact getNonce() {
        return (NonceCompact)this.getField("nonce");
    }

    public Signature getSignature() {
        return (Signature)this.getField("signature");
    }

    public Address getSigner() {
        return (Address)this.getField("signer");
    }

    public int version() {
        return ((U8)this.getField("version")).intValue();
    }

    private ExtrinsicSignature injectSignature(Signature signature, Address signer, NonceCompact nonce, ExtrinsicEra era) {
        this.put("era", era);
        this.put("nonce", nonce);
        this.put("signer", signer);
        this.put("signature", signature);
        this.put("version", new U8(129));
        return this;
    }

    ExtrinsicSignature addSignature(Object _signer, byte[] _signature, Object _nonce, byte[] _era) {
        Address signer = new Address(_signer);
        NonceCompact nonce = new NonceCompact(_nonce);
        ExtrinsicEra era = new ExtrinsicEra(_era);
        Signature signature = new Signature(_signature);
        return this.injectSignature(signature, signer, nonce, era);
    }

    ExtrinsicSignature sign(Method method, Types.KeyringPair account, Types.SignatureOptions signatureOptions) {
        Address signer = new Address(account.publicKey());
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("nonce", signatureOptions.getNonce());
        values.put("method", method);
        values.put("era", signatureOptions.getEra() == null ? IMMORTAL_ERA : signatureOptions.getEra());
        values.put("blockHash", signatureOptions.getBlockHash());
        SignaturePayload signingPayload = new SignaturePayload(values);
        Signature signature = new Signature(signingPayload.sign(account, (RuntimeVersion)signatureOptions.getVersion()));
        return this.injectSignature(signature, signer, signingPayload.getNonce(), signingPayload.getEra());
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        if (this.isSigned()) {
            return super.toU8a(isBare);
        }
        return new byte[]{(byte)this.version()};
    }
}

