/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.type;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.EnumType;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.Tuple;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.primitive.Bytes;
import org.polkadot.types.primitive.U32;
import org.polkadot.types.primitive.U64;
import org.polkadot.types.type.AuthorityId;
import org.polkadot.types.type.Hash;
import org.polkadot.types.type.Signature;

public class Digest
extends Struct {
    public Digest(Object value) {
        super(new Types.ConstructorDef().add("logs", Vector.with(TypesUtils.getConstructorCodec(DigestItem.class))), value);
    }

    public Vector<DigestItem> getLogs() {
        return (Vector)this.getField("logs");
    }

    public static class DigestItem
    extends EnumType {
        public DigestItem(Object value) {
            super(new Types.ConstructorDef().add("Other", Other.class).add("AuthoritiesChange", Vector.with(TypesUtils.getConstructorCodec(AuthorityId.class))).add("ChangesTrieRoot", ChangesTrieRoot.class).add("Seal", Seal.class).add("Consensus", Consensus.class), value, -1, null);
        }

        public Vector<AuthorityId> getAsAuthoritiesChange() {
            return (Vector)this.value();
        }

        public ChangesTrieRoot getAsChangesTrieRoot() {
            return (ChangesTrieRoot)this.value();
        }

        public Consensus getAsConsensus() {
            return (Consensus)this.value();
        }

        public Other getAsOther() {
            return (Other)this.value();
        }

        public Seal getAsSeal() {
            return (Seal)this.value();
        }

        public boolean isConsensus() {
            return this.getType().equals("Consensus");
        }

        public boolean isSeal() {
            return this.getType().equals("Seal");
        }
    }

    public static class Consensus
    extends Tuple {
        public Consensus(Object value) {
            super(new Types.ConstructorDef().add("U32", U32.class).add("Bytes", Bytes.class), value);
        }

        public boolean isAura() {
            return this.getEngine().eq(1634891105);
        }

        public U32 getEngine() {
            return (U32)this.getFiled(0);
        }

        public Bytes getData() {
            return (Bytes)this.getFiled(1);
        }

        public Pair<U64, Signature> asAura() {
            byte[] raw = this.getData().toU8a(true);
            byte[] subarray1 = ArrayUtils.subarray((byte[])raw, (int)0, (int)4);
            byte[] subarray2 = ArrayUtils.subarray((byte[])raw, (int)64, (int)raw.length);
            return Pair.of((Object)new U64((Object)subarray1), (Object)new Signature(subarray2));
        }
    }

    public static class Seal
    extends Tuple {
        public Seal(Object value) {
            super(new Types.ConstructorDef().add("U64", U64.class).add("Signature", Signature.class), value);
        }

        public Signature getSignature() {
            return (Signature)this.getFiled(1);
        }

        public U64 slot() {
            return (U64)this.getFiled(0);
        }
    }

    public static class ChangesTrieRoot
    extends Hash {
        public ChangesTrieRoot(Object value) {
            super(value);
        }
    }

    public static class AuthoritiesChange
    extends Vector<AuthorityId> {
        public AuthoritiesChange(Object value) {
            super(TypesUtils.getConstructorCodec(AuthorityId.class), value);
        }
    }

    public static class Other
    extends Bytes {
        public Other(Object value) {
            super(value);
        }
    }
}

