/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.type;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedBytes;
import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.common.keyring.address.AddressCodec;
import org.polkadot.types.Codec;
import org.polkadot.types.codec.Base;
import org.polkadot.types.type.AccountId;
import org.polkadot.types.type.AccountIndex;
import org.polkadot.utils.Utils;

public class Address
extends Base<Codec>
implements Codec {
    public static final byte[] ACCOUNT_ID_PREFIX = new byte[]{UnsignedBytes.checkedCast((long)255L)};

    public Address(Object value) {
        super(Address.decodeAddress(value == null ? (Object)new byte[0] : value));
    }

    static Codec decodeAddress(Object value) {
        if (value instanceof AccountId || value instanceof AccountIndex) {
            return (Codec)value;
        }
        if (value instanceof Number) {
            return new AccountIndex(value);
        }
        if (value instanceof Address) {
            return (Codec)((Address)value).raw;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            if (bytes.length == 32) {
                return new AccountId(value);
            }
            if (bytes.length > 0 && UnsignedBytes.toInt((byte)bytes[0]) == 255) {
                return new AccountId(ArrayUtils.subarray((byte[])bytes, (int)1, (int)bytes.length));
            }
            int[] results = AccountIndex.readLength(bytes);
            int offset = results[0];
            int length = results[1];
            return new AccountIndex(Utils.u8aToBn(ArrayUtils.subarray((byte[])bytes, (int)offset, (int)(offset + length)), true, false));
        }
        if (value.getClass().isArray()) {
            return Address.decodeAddress(Utils.u8aToU8a(value));
        }
        if (Utils.isHex(value)) {
            return Address.decodeAddress(Utils.hexToU8a((String)value));
        }
        byte[] decoded = AddressCodec.decodeAddress(value);
        return decoded.length == 32 ? new AccountId(decoded) : new AccountIndex(Utils.u8aToBn(decoded, true, false));
    }

    public int getRawLength() {
        return this.raw instanceof AccountIndex ? AccountIndex.calcLength((AccountIndex)this.raw) : ((Codec)this.raw).getEncodedLength();
    }

    @Override
    public int getEncodedLength() {
        int rawLength;
        return rawLength + ((rawLength = this.getRawLength()) > 1 ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return ((Codec)this.raw).isEmpty();
    }

    @Override
    public boolean eq(Object other) {
        return ((Codec)this.raw).eq(other);
    }

    @Override
    public String toHex() {
        return Utils.u8aToHex(this.toU8a());
    }

    @Override
    public Object toJson() {
        return ((Codec)this.raw).toJson();
    }

    public String toString() {
        return ((Codec)this.raw).toString();
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        byte[] encoded = ((Codec)this.raw).toU8a();
        encoded = ArrayUtils.subarray((byte[])encoded, (int)0, (int)this.getRawLength());
        return isBare ? encoded : Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{this.raw instanceof AccountIndex ? AccountIndex.writeLength(encoded) : ACCOUNT_ID_PREFIX, encoded}));
    }
}

