/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.type;

import org.polkadot.common.keyring.address.AddressCodec;
import org.polkadot.types.codec.U8a;
import org.polkadot.types.codec.U8aFixed;
import org.polkadot.utils.Utils;

public class AccountId
extends U8aFixed {
    public AccountId(Object value) {
        super(AccountId.decodeAccountId(value), 256);
    }

    static String encode(U8a value) {
        return AddressCodec.encodeAddress(value.toU8a());
    }

    private static byte[] decodeAccountId(Object value) {
        if (Utils.isU8a(value) || value.getClass().isArray()) {
            return Utils.u8aToU8a(value);
        }
        if (Utils.isHex(value)) {
            return Utils.hexToU8a(value.toString());
        }
        if (value instanceof String) {
            return AddressCodec.decodeAddress((String)value);
        }
        return (byte[])value;
    }

    @Override
    public boolean eq(Object other) {
        return super.eq(AccountId.decodeAccountId(other));
    }

    @Override
    public Object toJson() {
        return this.toString();
    }

    @Override
    public String toString() {
        return AccountId.encode(this);
    }

    public static class AccountIdOf
    extends AccountId {
        public AccountIdOf(Object value) {
            super(value);
        }
    }
}

