/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.metadata;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.types.codec.CreateType;
import org.polkadot.types.codec.TypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUtils {
    private static final Logger logger = LoggerFactory.getLogger(MetadataUtils.class);

    public static List<Object> flattenUniq(List<Object> list) {
        ArrayList reduce = list.stream().reduce(new ArrayList(), (r, e) -> {
            if (e.getClass().isArray()) {
                r.addAll(MetadataUtils.flattenUniq(CodecUtils.arrayLikeToList(e)));
            } else {
                r.add(e);
            }
            return r;
        }, (u, t) -> null);
        LinkedHashSet set = new LinkedHashSet();
        set.addAll(reduce);
        return new ArrayList<Object>(set);
    }

    private static List<Object> extractTypes(List<String> types) {
        return types.stream().map(type -> {
            CreateType.TypeDef decoded = CreateType.getTypeDef(type);
            List<CreateType.TypeDef> sub = decoded.getSub();
            switch (decoded.getInfo()) {
                case Plain: {
                    return decoded.getType();
                }
                case Compact: 
                case Option: 
                case Vector: 
                case Tuple: {
                    return MetadataUtils.extractTypes(sub.stream().map(def -> def.getType()).collect(Collectors.toList()));
                }
            }
            throw new UnsupportedOperationException("Unreachable" + (Object)((Object)decoded.getInfo()));
        }).collect(Collectors.toList());
    }

    public static void validateTypes(List<String> types, boolean throwError) {
        TypeRegistry typeRegistry = TypeRegistry.getDefaultRegistry();
        List<Object> realTypes = MetadataUtils.extractTypes(types);
        List<Object> uniqTypes = MetadataUtils.flattenUniq(realTypes);
        List missing = uniqTypes.stream().filter(t -> typeRegistry.get((String)t) == null).collect(Collectors.toList());
        if (!missing.isEmpty()) {
            String message = "Unknown types found, no types for " + missing;
            if (throwError) {
                throw new RuntimeException(message);
            }
            logger.error(message);
        }
    }
}

