/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.polkadot.common.keyring.Types;
import org.polkadot.types.Codec;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.U8a;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.Method;

public interface Types {

    public static abstract class Contract {
        protected ContractABI abi;
        protected ContractABIFn deploy;
        protected Map<String, ContractABIFn> messages;
    }

    public static interface ContractABIFn {
        public byte[] call(Object ... var1);

        public List<ContractABIArg> getArgs();

        public boolean isConstant();

        public String getType();
    }

    public static class ContractABI {
        public ContractABIMethodBase deploy;
        public List<ContractABIMethod> messages;
        public String name;
    }

    public static class ContractABIMethod
    extends ContractABIMethodBase {
        public boolean mutates;
        public String name;
        public long selector;
        public String returnType;
    }

    public static class ContractABIMethodBase {
        public List<ContractABIArg> args;
    }

    public static class ContractABIArg {
        public String name;
        public String type;
    }

    public static interface IExtrinsicSignature
    extends Codec {
        public boolean isSigned();
    }

    public static class SignatureOptions {
        Object blockHash = null;
        byte[] era = null;
        Object nonce = null;
        RuntimeVersionInterface version = null;

        public Object getBlockHash() {
            return this.blockHash;
        }

        public SignatureOptions setBlockHash(Object blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public byte[] getEra() {
            return this.era;
        }

        public SignatureOptions setEra(byte[] era) {
            this.era = era;
            return this;
        }

        public Object getNonce() {
            return this.nonce;
        }

        public SignatureOptions setNonce(Object nonce) {
            this.nonce = nonce;
            return this;
        }

        public RuntimeVersionInterface getVersion() {
            return this.version;
        }

        public SignatureOptions setVersion(RuntimeVersionInterface version) {
            this.version = version;
            return this;
        }
    }

    public static interface IExtrinsic
    extends IMethod {
        public U8a getHash();

        public boolean isSigned();

        public Method getMethod();

        public IExtrinsicSignature getSignature();

        public IExtrinsic addSignature(Object var1, byte[] var2, Object var3, byte[] var4);

        public IExtrinsic sign(Types.KeyringPair var1, SignatureOptions var2);
    }

    public static interface RuntimeVersionInterface {
        public List<? extends Object> getApis();

        public BigInteger getAuthoringVersion();

        public String getImplName();

        public BigInteger getImplVersion();

        public String getSpecName();

        public BigInteger getSpecVersion();
    }

    public static interface IMethod
    extends Codec {
        public List<Codec> getArgs();

        public ConstructorDef getArgsDef();

        public byte[] getCallIndex();

        public byte[] getData();

        public boolean hasOrigin();

        public Modules.FunctionMetadata getMeta();
    }

    public static class RegistryTypes {
        Map<String, Class<?>> registryTypes;
    }

    public static class ConstructorDef {
        List<String> names = new ArrayList<String>();
        List<ConstructorCodec> types = new ArrayList<ConstructorCodec>();
        List<Class> classes = new ArrayList<Class>();

        public ConstructorDef add(String name, ConstructorCodec<? extends Codec> type) {
            this.names.add(name);
            this.types.add(type);
            return this;
        }

        public ConstructorDef add(String name, Class<? extends Codec> clazz) {
            this.names.add(name);
            ConstructorCodec<? extends Codec> builder = TypesUtils.getConstructorCodec(clazz);
            this.types.add(builder);
            return this;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<ConstructorCodec> getTypes() {
            return this.types;
        }

        public ConstructorDef() {
        }

        public ConstructorDef(List<ConstructorCodec> list) {
            for (ConstructorCodec type : list) {
                String simpleName = type.getTClass().getSimpleName();
                this.add(simpleName, type);
            }
        }
    }

    public static interface ConstructorCodec<T extends Codec> {
        public T newInstance(Object ... var1);

        public Class<T> getTClass();
    }

    public static interface IHash
    extends Codec {
    }

    public static interface CodecCallback<T extends Codec> {
        public Object apply(T var1);
    }

    public static class CodecArg {
    }
}

