/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.type.storage;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.polkadot.types.Codec;
import org.polkadot.types.codec.CreateType;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.metadata.v2.Storage;
import org.polkadot.types.primitive.Bytes;
import org.polkadot.types.primitive.StorageKey;
import org.polkadot.utils.Utils;
import org.polkadot.utils.UtilsCrypto;

public class CreateFunction {
    public static StorageKey.StorageFunction createFunction(String section, String method, Modules.StorageFunctionMetadata meta, final boolean isUnhashed, String key) {
        final String stringKey = StringUtils.isNotEmpty((CharSequence)key) ? key : section + " " + method;
        final byte[] rawKey = Utils.stringToU8a(stringKey);
        StorageKey.StorageFunction storageFn = new StorageKey.StorageFunction(){
            String strKey;
            {
                this.strKey = stringKey;
            }

            @Override
            public byte[] apply(Object ... args) {
                byte[] key = rawKey;
                if (this.meta.getType().isMap()) {
                    assert (ArrayUtils.isNotEmpty((Object[])args)) : this.meta.getName() + "expects one argument";
                    String type = this.meta.getType().asMap().getKey().toString();
                    byte[] param = CreateType.createType(type, args[0]).toU8a(false);
                    key = Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{key, param}));
                }
                return Utils.compactAddLength(isUnhashed ? key : UtilsCrypto.xxhashAsU8a(key, 128));
            }

            @Override
            public Object toJson() {
                return this.getMeta().toJson();
            }
        };
        if (meta.getType().isMap() && meta.getType().asMap().isLinked()) {
            final byte[] keyHash = UtilsCrypto.xxhashAsU8a(("head of " + stringKey).getBytes(), 128);
            StorageKey.StorageFunction keyFn = new StorageKey.StorageFunction(){

                @Override
                public byte[] apply(Object ... args) {
                    return keyHash;
                }

                @Override
                public Object toJson() {
                    return this.getMeta().toJson();
                }
            };
            LinkedHashMap<String, Codec> metaValues = new LinkedHashMap<String, Codec>();
            metaValues.put("name", meta.getName());
            metaValues.put("modifier", new Modules.StorageFunctionModifier("Required"));
            metaValues.put("type", new Modules.StorageFunctionType(new Storage.PlainType(meta.getType().asMap().getKey()), 0));
            metaValues.put("default", new Bytes(null));
            metaValues.put("documentation", meta.getDocumentation());
            keyFn.setMeta(new Modules.StorageFunctionMetadata(metaValues));
            storageFn.setHeadKey(new StorageKey(keyFn));
        }
        storageFn.setMeta(meta);
        storageFn.setMethod(Utils.stringLowerFirst(method));
        storageFn.setSection(Utils.stringLowerFirst(section));
        return storageFn;
    }

    public static class CreateItemOptions {
        private boolean isUnhashed;
        private String key;

        public CreateItemOptions(boolean isUnhashed, String key) {
            this.isUnhashed = isUnhashed;
            this.key = key;
        }

        public boolean isUnhashed() {
            return this.isUnhashed;
        }

        public void setUnhashed(boolean unhashed) {
            this.isUnhashed = unhashed;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

