/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.common.keyring.pair;

import org.apache.commons.lang3.StringUtils;
import org.polkadot.common.keyring.Types;
import org.polkadot.common.keyring.address.AddressCodec;
import org.polkadot.common.keyring.pair.PairCodec;
import org.polkadot.common.keyring.pair.Types;
import org.polkadot.utils.crypto.Nacl;
import org.polkadot.utils.crypto.Schnorrkel;
import org.polkadot.utils.crypto.Types;

public interface Index {
    public static boolean isSr25519(String type) {
        return type.equals("sr25519");
    }

    public static Types.Keypair fromSeed(String type, byte[] seed) {
        return Index.isSr25519(type) ? Schnorrkel.schnorrkelKeypairFromSeed(seed) : Nacl.naclKeypairFromSeed(seed);
    }

    public static byte[] sign(String type, byte[] message, Types.Keypair pair) {
        return Index.isSr25519(type) ? Schnorrkel.schnorrkelSign(message, pair) : Nacl.naclSign(message, pair);
    }

    public static boolean verify(String type, byte[] message, byte[] signature, byte[] publicKey) {
        return Index.isSr25519(type) ? Schnorrkel.schnorrkelVerify(message, signature, publicKey) : Nacl.naclVerify(message, signature, publicKey);
    }

    public static Types.KeyringPair createPair(String type, Types.PairInfo pairInfo, Types.KeyringPairMeta meta, byte[] encoded) {
        return new KeyringPairDefault(type, pairInfo, meta, encoded);
    }

    public static class KeyringPairDefault
    implements Types.KeyringPair {
        String type;
        Types.PairInfo pairInfo;
        Types.KeyringPairMeta meta;
        byte[] encoded;

        public KeyringPairDefault(String type, Types.PairInfo pairInfo, Types.KeyringPairMeta meta, byte[] encoded) {
            this.type = type;
            this.pairInfo = pairInfo;
            this.meta = meta;
            this.encoded = encoded;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String address() {
            return AddressCodec.encodeAddress(this.pairInfo.getPublicKey());
        }

        @Override
        public void decodePkcs8(String passphrase, byte[] _encoded) {
            PairCodec.DecodeResult decoded = PairCodec.decode(passphrase, _encoded != null ? _encoded : this.encoded);
            if (decoded.getSecretKey().length == 64) {
                this.pairInfo.publicKey = decoded.getPublicKey();
                this.pairInfo.secretKey = decoded.getSecretKey();
            } else {
                Types.Keypair pair = Index.fromSeed(this.type, decoded.secretKey);
                this.pairInfo.publicKey = pair.getPublicKey();
                this.pairInfo.secretKey = pair.getSecretKey();
            }
        }

        @Override
        public byte[] encodePkcs8(String passphrase) {
            return PairCodec.encode(this.pairInfo, passphrase);
        }

        @Override
        public Types.KeyringPairMeta getMeta() {
            return this.meta;
        }

        @Override
        public boolean isLocked() {
            return this.pairInfo.secretKey == null || this.pairInfo.secretKey.length == 0;
        }

        @Override
        public void lock() {
            this.pairInfo.secretKey = new byte[0];
        }

        @Override
        public byte[] publicKey() {
            return this.pairInfo.publicKey;
        }

        @Override
        public void setMeta(Types.KeyringPairMeta meta) {
            this.meta.putAll(meta);
        }

        @Override
        public byte[] sign(byte[] message) {
            return Index.sign(this.type, message, new Types.Keypair(this.pairInfo.publicKey, this.pairInfo.secretKey));
        }

        @Override
        public Types.KeyringPairJson toJson(String passphrase) {
            return PairCodec.toJson(this.type, new PairCodec.PairStateJson(this.meta, this.pairInfo.publicKey), PairCodec.encode(this.pairInfo, passphrase), StringUtils.isNotEmpty((CharSequence)passphrase));
        }

        @Override
        public boolean verify(byte[] message, byte[] signature) {
            return Index.verify(this.type, message, signature, this.publicKey());
        }
    }
}

