/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api;

import com.google.common.collect.Lists;
import com.onehilltech.promises.Promise;
import java.util.List;
import org.polkadot.api.ApiBase;
import org.polkadot.api.ApiUtils;
import org.polkadot.api.Types;
import org.polkadot.common.keyring.Types;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.direct.ISection;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.TypeRegistry;
import org.polkadot.types.codec.U8a;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.Method;
import org.polkadot.types.rpc.ExtrinsicStatus;
import org.polkadot.types.rpc.SignedBlock;
import org.polkadot.types.type.EventRecord;
import org.polkadot.types.type.Extrinsic;
import org.polkadot.types.type.ExtrinsicSignature;
import org.polkadot.utils.MapUtils;

public interface SubmittableExtrinsic<ApplyResult>
extends Types.IExtrinsic {
    public ApplyResult send();

    public ApplyResult send(StatusCb var1);

    @Override
    public Types.IExtrinsic sign(Types.KeyringPair var1, Types.SignatureOptions var2);

    public ApplyResult signAndSend(Object var1, Types.SignatureOptions var2);

    public ApplyResult signAndSendCb(Object var1, StatusCb var2);

    public static void updateSigner(Types.ApiInterfacePromise apiInterfacePromise, int updateId, Object status) {
        if (updateId != -1 && apiInterfacePromise.getSigner() != null) {
            apiInterfacePromise.getSigner().update(updateId, status);
        }
    }

    public static Promise sendObservable(Types.ApiInterfacePromise apiInterfacePromise, int updateId, Types.IExtrinsic _extrinsic) {
        Promise submitExtrinsic;
        Promise invoke = submitExtrinsic = (Promise)((Types.DecoratedRpcMethod)apiInterfacePromise.rpc().author().function("submitExtrinsic")).invoke(_extrinsic);
        return invoke.then(hash -> {
            SubmittableExtrinsic.updateSigner(apiInterfacePromise, updateId, hash);
            return Promise.value((Object)hash);
        });
    }

    public static Promise subscribeObservable(Types.ApiInterfacePromise apiInterfacePromise, int updateId, Types.IExtrinsic _extrinsic, StatusCb trackingCb) {
        Types.DecoratedRpcMethod submitAndWatchExtrinsic = (Types.DecoratedRpcMethod)apiInterfacePromise.rpc().author().function("submitAndWatchExtrinsic");
        Object cb = null;
        if (trackingCb != null) {
            Promise invoke = (Promise)submitAndWatchExtrinsic.invoke(_extrinsic, status -> SubmittableExtrinsic.statusObservable(apiInterfacePromise, _extrinsic, (ExtrinsicStatus)status, trackingCb).then(result -> {
                SubmittableExtrinsic.updateSigner(apiInterfacePromise, updateId, result);
                return Promise.value((Object)result);
            }));
            return invoke;
        }
        Promise invoke = (Promise)submitAndWatchExtrinsic.invoke(_extrinsic);
        return invoke.then(status -> {
            Promise promise = SubmittableExtrinsic.statusObservable(apiInterfacePromise, _extrinsic, (ExtrinsicStatus)status, trackingCb);
            return promise;
        }).then(status -> {
            SubmittableExtrinsic.updateSigner(apiInterfacePromise, updateId, status);
            return Promise.value((Object)status);
        });
    }

    public static Promise statusObservable(Types.ApiInterfacePromise apiInterfacePromise, Types.IExtrinsic _extrinsic, ExtrinsicStatus status, StatusCb trackingCb) {
        if (!status.isFinalized()) {
            SubmittableResult result = new SubmittableResult(MapUtils.ofMap("status", status));
            if (trackingCb != null) {
                trackingCb.callback(result);
            }
            return Promise.value((Object)result);
        }
        ExtrinsicStatus.Finalized blockHash = status.asFinalized();
        System.out.println("====== handle status.isFinalized() " + blockHash);
        Types.DecoratedRpcMethod getBlock = (Types.DecoratedRpcMethod)apiInterfacePromise.rpc().chain().function("getBlock");
        Types.QueryableStorageFunction events = (Types.QueryableStorageFunction)apiInterfacePromise.query().section("system").function("events");
        System.out.println("======try get events");
        return Promise.all((Promise[])new Promise[]{(Promise)getBlock.invoke(blockHash), (Promise)events.at(blockHash, null)}).then(results -> {
            SignedBlock signedBlock = (SignedBlock)results.get(0);
            Vector allEvents = (Vector)results.get(1);
            System.out.println("====== get events" + allEvents);
            SubmittableResult result = new SubmittableResult(MapUtils.ofMap("events", ApiUtils.filterEvents(_extrinsic.getHash().toU8a(), signedBlock, allEvents), "status", status));
            if (trackingCb != null) {
                trackingCb.callback(result);
            }
            return Promise.value((Object)result);
        })._catch(err -> {
            err.printStackTrace();
            return null;
        });
    }

    public static <ApplyResult> SubmittableExtrinsic<ApplyResult> createSubmittableExtrinsic(ApiBase.ApiType apiType, final Types.ApiInterfacePromise apiPromise, Method extrinsic, StatusCb trackingCb, final Types.OnCallDefinition<ApplyResult> onCallDefinition) {
        Types.ConstructorCodec type = TypeRegistry.getDefaultRegistry().getOrThrow("Extrinsic", "erro");
        Types.IExtrinsic _extrinsic = (Types.IExtrinsic)type.newInstance(extrinsic);
        final boolean noStatusCb = apiType == ApiBase.ApiType.RX;
        SubmittableExtrinsicImpl submittableExtrinsic = new SubmittableExtrinsicImpl(_extrinsic){

            private Types.SignatureOptions expandOptions(Types.SignatureOptions options) {
                Types.SignatureOptions signatureOptions = new Types.SignatureOptions();
                signatureOptions.setBlockHash(apiPromise.getGenesisHash());
                signatureOptions.setVersion(apiPromise.getRuntimeVersion());
                if (options.getNonce() != null) {
                    signatureOptions.setNonce(options.getNonce());
                }
                if (options.getVersion() != null) {
                    signatureOptions.setVersion(options.getVersion());
                }
                if (options.getBlockHash() != null) {
                    signatureOptions.setBlockHash(options.getBlockHash());
                }
                if (options.getEra() != null) {
                    signatureOptions.setEra(options.getEra());
                }
                return signatureOptions;
            }

            @Override
            public ApplyResult send() {
                final boolean isSubscription = noStatusCb;
                return onCallDefinition.apply(new Types.OnCallFunction(){

                    @Override
                    public Promise apply(Object ... params) {
                        if (isSubscription) {
                            StatusCb statusCb = null;
                            return SubmittableExtrinsic.subscribeObservable(apiPromise, -1, _extrinsic, statusCb);
                        }
                        return SubmittableExtrinsic.sendObservable(apiPromise, -1, _extrinsic);
                    }
                }, Lists.newArrayList(), false, null);
            }

            @Override
            public ApplyResult send(final StatusCb callback) {
                return onCallDefinition.apply(new Types.OnCallFunction(){

                    @Override
                    public Promise apply(Object ... params) {
                        StatusCb statusCb = callback;
                        if (params != null && params.length > 0) {
                            final IRpcFunction.SubscribeCallback subscribeCallback = (IRpcFunction.SubscribeCallback)params[0];
                            statusCb = new StatusCb(){

                                @Override
                                public Object callback(SubmittableResult result) {
                                    subscribeCallback.callback(result);
                                    return null;
                                }
                            };
                        }
                        return SubmittableExtrinsic.subscribeObservable(apiPromise, -1, _extrinsic, statusCb);
                    }
                }, Lists.newArrayList(), true, callback == null ? null : new IRpcFunction.SubscribeCallback(){

                    public void callback(Object o) {
                        callback.callback((SubmittableResult)o);
                    }
                });
            }

            @Override
            public Extrinsic sign(Types.KeyringPair account, Types.SignatureOptions options) {
                Types.IExtrinsic sign = this._extrinsic.sign(account, this.expandOptions(options));
                return this;
            }

            @Override
            public ApplyResult signAndSend(final Object account, Types.SignatureOptions _options) {
                final Types.SignatureOptions options = _options == null ? new Types.SignatureOptions() : _options;
                final boolean isKeyringPair = account instanceof Types.KeyringPair;
                final String address = isKeyringPair ? ((Types.KeyringPair)account).address() : account.toString();
                ISection system = apiPromise.query().section("system");
                Types.QueryableStorageFunction accountNonce = (Types.QueryableStorageFunction)system.function("accountNonce");
                final Promise call = (Promise)accountNonce.call(address);
                final 1 self = this;
                return onCallDefinition.apply(new Types.OnCallFunction(){

                    @Override
                    public Promise apply(Object ... params) {
                        return call.then(nonce -> {
                            if (isKeyringPair) {
                                options.setNonce(nonce);
                                self.sign((Types.KeyringPair)account, options);
                                return Promise.value((Object)-1);
                            }
                            assert (apiPromise.getSigner() != null) : "no signer exists";
                            options.setBlockHash(apiPromise.getGenesisHash());
                            options.setVersion(apiPromise.getRuntimeVersion());
                            options.setNonce(nonce);
                            Promise<Integer> sign = apiPromise.getSigner().sign(_extrinsic, address, options);
                            return sign;
                        }).then(updateId -> SubmittableExtrinsic.sendObservable(apiPromise, (Integer)updateId, _extrinsic));
                    }
                }, Lists.newArrayList(), false, null);
            }

            @Override
            public ApplyResult signAndSendCb(final Object account, final StatusCb callback) {
                final Types.SignatureOptions options = new Types.SignatureOptions();
                final boolean isKeyringPair = account instanceof Types.KeyringPair;
                final String address = isKeyringPair ? ((Types.KeyringPair)account).address() : account.toString();
                ISection system = apiPromise.query().section("system");
                Types.QueryableStorageFunction accountNonce = (Types.QueryableStorageFunction)system.function("accountNonce");
                final Promise call = (Promise)accountNonce.call(address);
                final 1 self = this;
                return onCallDefinition.apply(new Types.OnCallFunction(){

                    @Override
                    public Promise apply(Object ... params) {
                        StatusCb statusCb = callback;
                        if (params != null && params.length > 0) {
                            final IRpcFunction.SubscribeCallback subscribeCallback = (IRpcFunction.SubscribeCallback)params[0];
                            statusCb = new StatusCb(){

                                @Override
                                public Object callback(SubmittableResult result) {
                                    subscribeCallback.callback(result);
                                    return null;
                                }
                            };
                        }
                        StatusCb finalStatusCb = statusCb;
                        return call.then(nonce -> {
                            if (isKeyringPair) {
                                options.setNonce(nonce);
                                self.sign((Types.KeyringPair)account, options);
                                return Promise.value((Object)-1);
                            }
                            assert (apiPromise.getSigner() != null) : "no signer exists";
                            Types.SignatureOptions expandOptions = this.expandOptions(options);
                            Promise<Integer> sign = apiPromise.getSigner().sign(_extrinsic, address, expandOptions);
                            return sign;
                        }).then(updateId -> SubmittableExtrinsic.subscribeObservable(apiPromise, (Integer)updateId, _extrinsic, finalStatusCb));
                    }
                }, Lists.newArrayList(), true, callback == null ? null : new IRpcFunction.SubscribeCallback(){

                    public void callback(Object o) {
                        callback.callback((SubmittableResult)o);
                    }
                });
            }
        };
        return submittableExtrinsic;
    }

    public static abstract class SubmittableExtrinsicImpl
    extends Extrinsic
    implements SubmittableExtrinsic {
        Types.IExtrinsic _extrinsic;

        public SubmittableExtrinsicImpl(Types.IExtrinsic _extrinsic) {
            super(_extrinsic);
            this._extrinsic = _extrinsic;
        }

        @Override
        public List<Codec> getArgs() {
            return this._extrinsic.getArgs();
        }

        @Override
        public Types.ConstructorDef getArgsDef() {
            return this._extrinsic.getArgsDef();
        }

        @Override
        public byte[] getCallIndex() {
            return this._extrinsic.getCallIndex();
        }

        @Override
        public byte[] getData() {
            return this._extrinsic.getData();
        }

        @Override
        public boolean hasOrigin() {
            return this._extrinsic.hasOrigin();
        }

        @Override
        public Modules.FunctionMetadata getMeta() {
            return this._extrinsic.getMeta();
        }

        @Override
        public U8a getHash() {
            return this._extrinsic.getHash();
        }

        @Override
        public boolean isSigned() {
            return this._extrinsic.isSigned();
        }

        @Override
        public Method getMethod() {
            return this._extrinsic.getMethod();
        }

        @Override
        public ExtrinsicSignature getSignature() {
            return (ExtrinsicSignature)this._extrinsic.getSignature();
        }

        @Override
        public Extrinsic addSignature(Object signer, byte[] signature, Object nonce, byte[] era) {
            return (Extrinsic)this._extrinsic.addSignature(signer, signature, nonce, era);
        }

        @Override
        public int getEncodedLength() {
            return this._extrinsic.getEncodedLength();
        }

        @Override
        public boolean isEmpty() {
            return this._extrinsic.isEmpty();
        }

        @Override
        public boolean eq(Object other) {
            return this._extrinsic.eq(other);
        }

        @Override
        public String toHex() {
            return this._extrinsic.toHex();
        }

        @Override
        public Object toJson() {
            return this._extrinsic.toJson();
        }

        @Override
        public byte[] toU8a() {
            return this._extrinsic.toU8a();
        }

        @Override
        public byte[] toU8a(boolean isBare) {
            return this._extrinsic.toU8a(isBare);
        }
    }

    public static class SubmittableResult
    extends Struct {
        public SubmittableResult(Object value) {
            super(new Types.ConstructorDef().add("events", Vector.with(TypesUtils.getConstructorCodec(EventRecord.class))).add("status", ExtrinsicStatus.class), value);
        }

        public List<EventRecord> getEvents() {
            return (List)this.getField("events");
        }

        public ExtrinsicStatus getStatus() {
            return (ExtrinsicStatus)this.getField("status");
        }

        public EventRecord findRecord(String section, String method) {
            return this.getEvents().stream().filter(eventRecord -> eventRecord.getEvent().getSection().equals(section) && eventRecord.getEvent().getMethod().equals(method)).findFirst().orElse(null);
        }
    }

    public static interface StatusCb {
        public Object callback(SubmittableResult var1);
    }
}

