/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Date;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.params.AbstractBitcoinNetParams;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;

public class TestNet3Params
extends AbstractBitcoinNetParams {
    public static final int TESTNET_MAJORITY_WINDOW = 100;
    public static final int TESTNET_MAJORITY_REJECT_BLOCK_OUTDATED = 75;
    public static final int TESTNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 51;
    private static TestNet3Params instance;
    private static final Date testnetDiffDate;

    public TestNet3Params() {
        this.id = "org.bitcoin.test";
        this.packetMagic = 185665799L;
        this.interval = 2016;
        this.targetTimespan = 1209600;
        this.maxTarget = Utils.decodeCompactBits(486604799L);
        this.port = 18333;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.dumpedPrivateKeyHeader = 239;
        this.segwitAddressHrp = "tb";
        this.genesisBlock.setTime(1296688602L);
        this.genesisBlock.setDifficultyTarget(486604799L);
        this.genesisBlock.setNonce(414098458L);
        this.spendableCoinbaseDepth = 100;
        this.subsidyDecreaseBlockCount = 210000;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("000000000933ea01ad0ee984209779baaec3ced90fa3f408719526f8d77f4943"));
        this.alertSigningKey = Utils.HEX.decode((CharSequence)"04302390343f91cc401d56d68b123028bf52e5fca1939df127f63c6467cdf9c8e2c14b61104cf817d0b780da337893ecc4aaff1309e536162dabbdb45200ca2b0a");
        this.dnsSeeds = new String[]{"testnet-seed.bitcoin.jonasschnelli.ch", "seed.tbtc.petertodd.org", "seed.testnet.bitcoin.sprovoost.nl", "testnet-seed.bluematt.me", "bitcoin-testnet.bloqseeds.net"};
        this.addrSeeds = null;
        this.bip32HeaderP2PKHpub = 70617039;
        this.bip32HeaderP2PKHpriv = 70615956;
        this.bip32HeaderP2WPKHpub = 73342198;
        this.bip32HeaderP2WPKHpriv = 73341116;
        this.majorityEnforceBlockUpgrade = 51;
        this.majorityRejectBlockOutdated = 75;
        this.majorityWindow = 100;
    }

    public static synchronized TestNet3Params get() {
        if (instance == null) {
            instance = new TestNet3Params();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "test";
    }

    @Override
    public void checkDifficultyTransitions(StoredBlock storedPrev, Block nextBlock, BlockStore blockStore) throws VerificationException, BlockStoreException {
        if (!this.isDifficultyTransitionPoint(storedPrev.getHeight()) && nextBlock.getTime().after(testnetDiffDate)) {
            Block prev = storedPrev.getHeader();
            long timeDelta = nextBlock.getTimeSeconds() - prev.getTimeSeconds();
            if (timeDelta >= 0L && timeDelta <= 1200L) {
                BigInteger newTarget;
                StoredBlock cursor = storedPrev;
                while (!cursor.getHeader().equals(this.getGenesisBlock()) && cursor.getHeight() % this.getInterval() != 0 && cursor.getHeader().getDifficultyTargetAsInteger().equals(this.getMaxTarget())) {
                    cursor = cursor.getPrev(blockStore);
                }
                BigInteger cursorTarget = cursor.getHeader().getDifficultyTargetAsInteger();
                if (!cursorTarget.equals(newTarget = nextBlock.getDifficultyTargetAsInteger())) {
                    throw new VerificationException("Testnet block transition that is not allowed: " + Long.toHexString(cursor.getHeader().getDifficultyTarget()) + " vs " + Long.toHexString(nextBlock.getDifficultyTarget()));
                }
            }
        } else {
            super.checkDifficultyTransitions(storedPrev, nextBlock, blockStore);
        }
    }

    static {
        testnetDiffDate = new Date(1329264000000L);
    }
}

