/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.polkadot.utils.Utils;
import org.polkadot.utils.crypto.TweetNaCl;

public class UtilsCrypto {
    public static byte[] blake2AsU8a(byte[] data, int bitLength, byte[] key) {
        int byteLength = (int)Math.ceil((float)bitLength / 8.0f);
        Blake2bDigest blake2bkeyed = new Blake2bDigest(key, byteLength, null, null);
        blake2bkeyed.reset();
        blake2bkeyed.update(data, 0, data.length);
        byte[] keyedHash = new byte[64];
        int digestLength = blake2bkeyed.doFinal(keyedHash, 0);
        return ArrayUtils.subarray((byte[])keyedHash, (int)0, (int)digestLength);
    }

    public static byte[] blake2AsU8a(byte[] data) {
        return UtilsCrypto.blake2AsU8a(data, 256, null);
    }

    public static byte[] blake2AsU8a(byte[] data, int bitLength) {
        return UtilsCrypto.blake2AsU8a(data, bitLength, null);
    }

    public static byte[] xxhashAsU8a(byte[] data) {
        return UtilsCrypto.xxhashAsU8a(data, 64);
    }

    public static byte[] xxhashAsU8a(byte[] data, int bitLength) {
        int iterations = (int)Math.ceil((float)bitLength / 64.0f);
        byte[] u8a = new byte[(int)Math.ceil((float)bitLength / 8.0f)];
        for (int seed = 0; seed < iterations; ++seed) {
            BigInteger bigInteger = UtilsCrypto.xxhash64AsBn(data, seed);
            byte[] bytes = Utils.bnToU8a(bigInteger, true, 64);
            System.arraycopy(bytes, 0, u8a, seed * 8, 8);
        }
        return u8a;
    }

    public static BigInteger xxhash64AsBn(byte[] data, long seed) {
        String hash = UtilsCrypto.xxhash64AsRaw(data, seed);
        return new BigInteger(hash, 16);
    }

    public static String xxhash64AsRaw(byte[] data, long seed) {
        return Long.toHexString(UtilsCrypto.xxhash64AsValue(data, seed));
    }

    public static long xxhash64AsValue(byte[] data, long seed) {
        XXHashFactory factory = XXHashFactory.fastestInstance();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        StreamingXXHash64 xxHash64 = factory.newStreamingHash64(seed);
        byte[] buf = new byte[16];
        while (true) {
            int read = 0;
            try {
                read = in.read(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (read == -1) break;
            xxHash64.update(buf, 0, read);
        }
        long hash = xxHash64.getValue();
        return hash;
    }

    public static byte[] randomAsU8a(int length) {
        byte[] ret = new byte[length];
        TweetNaCl.randombytes(ret, length);
        return ret;
    }

    public static byte[] randomAsU8a() {
        return UtilsCrypto.randomAsU8a(32);
    }

    public static String randomAsHex(int length) {
        return Utils.u8aToHex(UtilsCrypto.randomAsU8a(length));
    }

    public static String randomAsHex() {
        return UtilsCrypto.randomAsHex(32);
    }

    public static void main(String[] args) {
        System.out.println(Long.toHexString(UtilsCrypto.xxhash64AsValue("abcd".getBytes(), 43981L)));
        System.out.println(UtilsCrypto.xxhash64AsRaw("abcd".getBytes(), 43981L));
        System.out.println(Utils.u8aToHex(UtilsCrypto.xxhashAsU8a("abc".getBytes())));
    }
}

