/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.type;

import org.polkadot.common.keyring.Types;
import org.polkadot.types.Types;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.primitive.Method;
import org.polkadot.types.rpc.RuntimeVersion;
import org.polkadot.types.type.ExtrinsicEra;
import org.polkadot.types.type.Hash;
import org.polkadot.types.type.NonceCompact;
import org.polkadot.utils.UtilsCrypto;

public class SignaturePayload
extends Struct {
    protected byte[] _signature;

    public SignaturePayload(Object value) {
        super(new Types.ConstructorDef().add("nonce", NonceCompact.class).add("method", Method.class).add("era", ExtrinsicEra.class).add("blockHash", Hash.class), value);
    }

    public boolean isSigned() {
        return this._signature != null && this._signature.length == 64;
    }

    public Hash getBlockHash() {
        return (Hash)this.getField("blockHash");
    }

    public Method getMethod() {
        return (Method)this.getField("method");
    }

    public ExtrinsicEra getEra() {
        return (ExtrinsicEra)this.getField("era");
    }

    public NonceCompact getNonce() {
        return (NonceCompact)this.getField("nonce");
    }

    public byte[] getSignature() {
        if (!this.isSigned()) {
            throw new RuntimeException("Transaction is not signed");
        }
        return this._signature;
    }

    public byte[] sign(Types.KeyringPair signerPair, RuntimeVersion version) {
        byte[] u8a = this.toU8a();
        byte[] encoded = u8a.length > 256 ? UtilsCrypto.blake2AsU8a(u8a) : u8a;
        this._signature = signerPair.sign(encoded);
        return this._signature;
    }

    public static class SignaturePayloadValue {
        Object nonce;
        Method method;
        ExtrinsicEra era;
        Hash blockHash;
    }
}

