/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.primitive;

import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.types.codec.Compactable;
import org.polkadot.utils.Utils;

public class Moment
extends Date
implements Compactable {
    protected Date raw;
    public static int BITLENGTH = 64;

    public Moment(Object value) {
        this.raw = Moment.decodeMoment(value);
        this.setTime(this.raw.getTime());
    }

    static Date decodeMoment(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (Utils.isU8a(value)) {
            byte[] bytes = Utils.u8aToU8a(value);
            value = Utils.u8aToBn(ArrayUtils.subarray((byte[])bytes, (int)0, (int)(BITLENGTH / 8)), true, false);
        } else if (value instanceof String) {
            value = new BigInteger((String)value, 10);
        }
        return new Date(Utils.bnToBn(value).longValue() * 1000L);
    }

    @Override
    public int getEncodedLength() {
        return BITLENGTH / 8;
    }

    @Override
    public boolean isEmpty() {
        return this.getTime() == 0L;
    }

    @Override
    public boolean eq(Object other) {
        return Moment.decodeMoment(other).getTime() == this.getTime();
    }

    @Override
    public int bitLength() {
        return BITLENGTH;
    }

    @Override
    public BigInteger toBn() {
        return BigInteger.valueOf(this.toNumber());
    }

    @Override
    public String toHex() {
        return Utils.bnToHex(this.toBn(), BITLENGTH);
    }

    @Override
    public Object toJson() {
        return this.toNumber();
    }

    @Override
    public long toNumber() {
        return (long)Math.ceil(this.getTime() / 1000L);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        return Utils.bnToU8a(this.toBn(), true, false, BITLENGTH);
    }

    public static class MomentOf
    extends Moment {
        public MomentOf(Object value) {
            super(value);
        }
    }
}

