/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.metadata.v3;

import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.EnumType;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.v1.Storage;
import org.polkadot.types.metadata.v2.Storage;
import org.polkadot.types.primitive.Bytes;
import org.polkadot.types.primitive.Text;

public interface Storage {

    public static class MetadataStorageV3
    extends Struct {
        public MetadataStorageV3(Object value) {
            super(new Types.ConstructorDef().add("name", Text.class).add("modifier", Storage.MetadataStorageModifier.class).add("type", MetadataStorageType.class).add("fallback", Bytes.class).add("docs", Vector.with(TypesUtils.getConstructorCodec(Text.class))), value);
        }

        public Vector<Text> getDocs() {
            return (Vector)this.getField("docs");
        }

        public Bytes getFallback() {
            return (Bytes)this.getField("fallback");
        }

        public Storage.MetadataStorageModifier getModifier() {
            return (Storage.MetadataStorageModifier)this.getField("modifier");
        }

        public Text getName() {
            return (Text)this.getField("name");
        }

        public MetadataStorageType getType() {
            return (MetadataStorageType)this.getField("type");
        }
    }

    public static class MetadataStorageType
    extends EnumType {
        public MetadataStorageType(Object value, int index) {
            super(new Types.ConstructorDef().add("PlainType", Storage.PlainType.class).add("MapType", Storage.MapType.class).add("DoubleMapType", DoubleMapType.class), value, index, null);
        }

        public MetadataStorageType(Object value) {
            this(value, -1);
        }

        public DoubleMapType asDoubleMap() {
            return (DoubleMapType)this.value();
        }

        public boolean isDoubleMap() {
            return this.toNumber() == 2;
        }

        public boolean isMap() {
            return this.toNumber() == 1;
        }

        public Storage.MapType asMap() {
            return (Storage.MapType)this.value();
        }

        public Storage.PlainType asType() {
            return (Storage.PlainType)this.value();
        }

        @Override
        public String toString() {
            if (this.isDoubleMap()) {
                return this.asDoubleMap().toString();
            }
            return this.isMap() ? this.asMap().getValue().toString() : this.asType().toString();
        }
    }

    public static class DoubleMapType
    extends Struct {
        public DoubleMapType(Object value) {
            super(new Types.ConstructorDef().add("key1", Text.class).add("key2", Text.class).add("value", Text.class).add("keyHasher", Text.class), value);
        }

        public Text getKey1() {
            return (Text)this.getField("key1");
        }

        public Text getKey2() {
            return (Text)this.getField("key2");
        }

        public Text getKeyHasher() {
            return (Text)this.getField("keyHasher");
        }

        public Text getValue() {
            return (Text)this.getField("value");
        }
    }
}

