/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.metadata.v2;

import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.EnumType;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.v1.Storage;
import org.polkadot.types.primitive.Bool;
import org.polkadot.types.primitive.Bytes;
import org.polkadot.types.primitive.Null;
import org.polkadot.types.primitive.Text;
import org.polkadot.types.primitive.Type;

public interface Storage {

    public static class MetadataStorageV2
    extends Struct {
        public MetadataStorageV2(Object value) {
            super(new Types.ConstructorDef().add("name", Text.class).add("modifier", Storage.MetadataStorageModifier.class).add("type", MetadataStorageType.class).add("fallback", Bytes.class).add("docs", Vector.with(TypesUtils.getConstructorCodec(Text.class))), value);
        }

        public Vector<Text> getDocs() {
            return (Vector)this.getField("docs");
        }

        public Bytes getFallback() {
            return (Bytes)this.getField("fallback");
        }

        public Storage.MetadataStorageModifier getModifier() {
            return (Storage.MetadataStorageModifier)this.getField("modifier");
        }

        public Text getName() {
            return (Text)this.getField("name");
        }

        public MetadataStorageType getType() {
            return (MetadataStorageType)this.getField("type");
        }
    }

    public static class MetadataStorageType
    extends EnumType {
        public MetadataStorageType(Object value) {
            this(value, -1);
        }

        public MetadataStorageType(Object value, int index) {
            super(new Types.ConstructorDef().add("PlainType", PlainType.class).add("MapType", MapType.class), value, index, null);
        }

        public boolean isMap() {
            return this.toNumber() == 1;
        }

        public MapType asMap() {
            return (MapType)this.value();
        }

        public PlainType asType() {
            return (PlainType)this.value();
        }

        @Override
        public String toString() {
            return this.isMap() ? this.asMap().getValue().toString() : this.asType().toString();
        }
    }

    public static class MapType
    extends Struct {
        public MapType(Object value) {
            super(new Types.ConstructorDef().add("key", Type.class).add("value", Type.class).add("isLinked", Bool.class), value);
        }

        public Type getKey() {
            return (Type)this.getField("key");
        }

        public Type getValue() {
            return (Type)this.getField("value");
        }

        public Boolean isLinked() {
            return (Boolean)this.getField("isLinked");
        }
    }

    public static class PlainType
    extends Type {
        public PlainType(Object value) {
            super(value);
        }
    }

    public static class Optional
    extends Null {
    }

    public static class Default
    extends Null {
    }
}

