/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.Base;
import org.polkadot.types.primitive.Null;
import org.polkadot.utils.Utils;

public class EnumType<T>
extends Base<Codec>
implements Codec {
    private Types.ConstructorDef def;
    private int index;
    private List<Integer> indexes;

    public EnumType(Types.ConstructorDef def, Object value, int index, LinkedHashMap<String, String> aliasses) {
        super((Codec)EnumType.decodeEnumType(def, aliasses, value, index).getValue());
        Pair<Integer, Codec> pair = EnumType.decodeEnumType(def, aliasses, value, index);
        this.def = def;
        AtomicInteger i = new AtomicInteger();
        this.indexes = def.getNames().stream().map(e -> i.getAndIncrement()).collect(Collectors.toList());
        this.index = this.indexes.indexOf(pair.getLeft());
        if (this.index < 0) {
            this.index = 0;
        }
    }

    private static <T> Pair<Integer, Codec> decodeEnumType(Types.ConstructorDef def, LinkedHashMap<String, String> aliasses, Object value, EnumType<T> index) {
        if (index != null) {
            return EnumType.createValue(def, index.index, index.raw);
        }
        return EnumType.decodeViaValue(def, aliasses, value);
    }

    private static Pair<Integer, Codec> decodeEnumType(Types.ConstructorDef def, LinkedHashMap<String, String> aliasses, Object value, int index) {
        if (index >= 0) {
            return EnumType.createValue(def, index, value);
        }
        return EnumType.decodeViaValue(def, aliasses, value);
    }

    private static Pair<Integer, Codec> decodeViaValue(Types.ConstructorDef def, LinkedHashMap<String, String> aliasses, Object value) {
        if (value instanceof EnumType) {
            return EnumType.createValue(def, ((EnumType)value).index, ((EnumType)value).raw);
        }
        if (Utils.isU8a(value)) {
            byte[] u8a = (byte[])value;
            return EnumType.createValue(def, u8a[0], Arrays.copyOfRange(u8a, 1, u8a.length));
        }
        if (value instanceof Number) {
            return EnumType.createValue(def, ((Number)value).intValue(), null);
        }
        if (value instanceof String) {
            String str = value.toString();
            return Utils.isHex(str) ? EnumType.decodeViaValue(def, aliasses, Utils.hexToU8a(str)) : EnumType.createViaJSON(def, aliasses, str, null);
        }
        if (value instanceof Map) {
            Map value1 = (Map)value;
            Object key = value1.keySet().stream().findFirst().orElse(null);
            return EnumType.createViaJSON(def, aliasses, key, value1.get(key));
        }
        return EnumType.createValue(def, 0, null);
    }

    /*
     * Exception decompiling
     */
    private static Pair<Integer, Codec> createViaJSON(Types.ConstructorDef def, LinkedHashMap<String, String> aliasses, String key, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Pair<Integer, Codec> createValue(Types.ConstructorDef def, int index, Object value) {
        Types.ConstructorCodec constructorCodec = def.getTypes().get(index);
        Object codec = constructorCodec.newInstance(value);
        return Pair.of((Object)index, codec);
    }

    public static Types.ConstructorCodec<EnumType> with(Types.ConstructorDef def) {
        return new Builder(def);
    }

    public int toNumber() {
        return this.index;
    }

    public Codec value() {
        return (Codec)this.raw;
    }

    public String getType() {
        return this.def.getNames().get(this.index);
    }

    public int index() {
        return this.index;
    }

    public boolean isNull() {
        return this.raw instanceof Null;
    }

    @Override
    public int getEncodedLength() {
        return 1 + ((Codec)this.raw).getEncodedLength();
    }

    @Override
    public boolean isEmpty() {
        return ((Codec)this.raw).isEmpty();
    }

    public boolean isNone() {
        return this.isNull();
    }

    @Override
    public boolean eq(Object other) {
        if (other instanceof Number) {
            return this.toNumber() == ((Number)other).intValue();
        }
        return this.value().eq(other);
    }

    @Override
    public String toHex() {
        return Utils.u8aToHex(this.toU8a());
    }

    @Override
    public Object toJson() {
        JSONObject jsonObject = new JSONObject();
        String type = this.getType();
        jsonObject.put(type, ((Codec)this.raw).toJson());
        return jsonObject;
    }

    public String toString() {
        return this.isNull() ? this.getType() : JSON.toJSONString((Object)this.toJson());
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        Integer index = this.indexes.get(this.index);
        return Utils.u8aConcat(Lists.newArrayList((Object[])new byte[][]{{index.byteValue()}, ((Codec)this.raw).toU8a(isBare)}));
    }

    public boolean isType(String value) {
        return this.getType().equals(value);
    }

    private static /* synthetic */ String lambda$createViaJSON$4(String[] sa) {
        return sa[1];
    }

    private static /* synthetic */ String lambda$createViaJSON$3(String[] sa) {
        return sa[0];
    }

    static class Builder
    implements Types.ConstructorCodec<EnumType> {
        Types.ConstructorDef def;

        Builder(Types.ConstructorDef def) {
            this.def = def;
        }

        @Override
        public EnumType<Types.ConstructorDef> newInstance(Object ... value) {
            return new EnumType<Types.ConstructorDef>(this.def, value[0], (Integer)value[1], null);
        }

        @Override
        public Class<EnumType> getTClass() {
            return EnumType.class;
        }
    }

    public static interface EnumConstructor<T extends Codec> {
        public T newInstance(Object var1, int var2);
    }
}

