/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import java.math.BigInteger;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.Base;
import org.polkadot.types.codec.Compactable;
import org.polkadot.utils.Utils;

public class Compact
extends Base<Compactable>
implements Codec {
    public Compact(Types.ConstructorCodec<? extends Compactable> type, Object value) {
        super(Compact.decodeCompact(type, value));
    }

    public static Types.ConstructorCodec<Compact> with(Types.ConstructorCodec<? extends Compactable> type) {
        return new Builder(type);
    }

    static Compactable decodeCompact(Types.ConstructorCodec<? extends Compactable> type, Object value) {
        if (value instanceof Compact) {
            return type.newInstance(((Compact)value).raw);
        }
        if (value instanceof String) {
            return type.newInstance(Utils.isHex(value, -1, true) ? Utils.hexToBn(value, false, false) : new BigInteger((String)value, 10));
        }
        if (value instanceof Number) {
            return type.newInstance(Utils.bnToBn(value));
        }
        Pair<Integer, BigInteger> pair = Utils.compactFromU8a(value, type.newInstance(0).bitLength());
        return type.newInstance(pair.getRight());
    }

    public BigInteger toBn() {
        return ((Compactable)this.raw).toBn();
    }

    @Override
    public int getEncodedLength() {
        return this.toU8a().length;
    }

    @Override
    public boolean isEmpty() {
        return ((Compactable)this.raw).isEmpty();
    }

    public int bitLength() {
        return ((Compactable)this.raw).bitLength();
    }

    @Override
    public boolean eq(Object other) {
        return ((Compactable)this.raw).eq(other instanceof Compact ? ((Compact)other).raw : other);
    }

    @Override
    public String toHex() {
        return ((Compactable)this.raw).toHex();
    }

    @Override
    public Object toJson() {
        return ((Compactable)this.raw).toJson();
    }

    public long toNumber() {
        return ((Compactable)this.raw).toNumber();
    }

    public String toString() {
        return ((Compactable)this.raw).toString();
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        return Utils.compactToU8a(((Compactable)this.raw).toBn());
    }

    static class Builder
    implements Types.ConstructorCodec<Compact> {
        Types.ConstructorCodec<Compactable> type;

        Builder(Types.ConstructorCodec type) {
            this.type = type;
        }

        @Override
        public Compact newInstance(Object ... values) {
            return new Compact(this.type, values[0]);
        }

        @Override
        public Class<Compact> getTClass() {
            return Compact.class;
        }
    }
}

