/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;

public class CodecUtils {
    public static List<Codec> decodeU8a(byte[] u8a, Types.ConstructorDef types) {
        ArrayList results = Lists.newArrayList();
        CodecUtils.decodeU8a(u8a, types.getTypes(), results);
        return results;
    }

    public static void decodeU8a(byte[] u8a, List<Types.ConstructorCodec> types, List<Codec> results) {
        if (CollectionUtils.isEmpty(types)) {
            return;
        }
        Types.ConstructorCodec constructorCodec = types.get(0);
        Object codec = constructorCodec.newInstance(new Object[]{u8a});
        results.add((Codec)codec);
        byte[] subarray = ArrayUtils.subarray((byte[])u8a, (int)codec.getEncodedLength(), (int)u8a.length);
        CodecUtils.decodeU8a(subarray, types.subList(1, types.size()), results);
    }

    public static List<Codec> decodeU8a(byte[] u8a, List<Types.ConstructorCodec> types) {
        Types.ConstructorCodec constructorCodec = types.get(0);
        throw new UnsupportedOperationException();
    }

    public static List<Object> arrayLikeToList(Object value) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (value == null) {
            return ret;
        }
        if (value instanceof List) {
            for (Object obj : (List)value) {
                ret.add(obj);
            }
            return ret;
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    Object obj = Array.get(value, i);
                    ret.add(obj);
                }
            } else {
                Object[] objects;
                for (Object obj : objects = (Object[])value) {
                    ret.add(obj);
                }
            }
            return ret;
        }
        return ret;
    }

    public static boolean compareMap(Map map1, Object obj) {
        if (obj.getClass().isArray()) {
            List<Object> objectList = CodecUtils.arrayLikeToList(obj);
            if (objectList.size() != map1.size()) {
                return false;
            }
            for (Object o : objectList) {
                List<Object> entry = CodecUtils.arrayLikeToList(o);
                if (entry.size() != 2) {
                    return false;
                }
                Object v1 = map1.get(entry.get(0));
                if (v1 == null) {
                    return false;
                }
                if (v1 instanceof Codec && !((Codec)v1).eq(entry.get(1))) {
                    return false;
                }
                if (v1.equals(entry.get(1))) continue;
                return false;
            }
            return true;
        }
        Map map2 = null;
        if (!(obj instanceof Map)) {
            return false;
        }
        map2 = (Map)obj;
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry _entry : map1.entrySet()) {
            Map.Entry entry = _entry;
            Object v2 = map2.get(entry.getKey());
            if (v2 == null) {
                return false;
            }
            if (v2 instanceof Codec && entry.getValue() instanceof Codec && !((Codec)v2).eq(entry.getValue())) {
                return false;
            }
            if (v2.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean compareArray(List list, Object other) {
        List<Object> objects = CodecUtils.arrayLikeToList(other);
        if (objects.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (o instanceof Codec && !((Codec)o).eq(objects.get(i))) {
                return false;
            }
            if (o.equals(objects.get(i))) continue;
            return false;
        }
        return true;
    }
}

