/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.primitive.Null;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesUtils {
    private static final Logger logger = LoggerFactory.getLogger(TypesUtils.class);
    public static Map<Class, Types.ConstructorCodec> constructorCodecMap = new ConcurrentHashMap<Class, Types.ConstructorCodec>();

    private static <T extends Codec> Types.ConstructorCodec<T> getBuilderConstructorCodec(Class<T> clazz) {
        try {
            Method builderMethod = clazz.getDeclaredMethod("builder", new Class[0]);
            Object builder = builderMethod.invoke(null, null);
            return (Types.ConstructorCodec)builder;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static <T extends Codec> Types.ConstructorCodec<T> getConstructorCodec(Class<T> clazz) {
        return constructorCodecMap.computeIfAbsent(clazz, clz -> TypesUtils.getConstructorCodecInner(clz));
    }

    private static <T extends Codec> Types.ConstructorCodec<T> getConstructorCodecInner(final Class<T> clazz) {
        Types.ConstructorCodec<T> builderConstructorCodec = TypesUtils.getBuilderConstructorCodec(clazz);
        if (builderConstructorCodec != null) {
            return builderConstructorCodec;
        }
        return new Types.ConstructorCodec<T>(){

            @Override
            public T newInstance(Object ... values) {
                Object[] params;
                Constructor<?>[] constructors = clazz.getConstructors();
                if (constructors.length < 1) {
                    logger.error(" no constructor {}, {}", (Object)clazz, constructors);
                    return null;
                }
                Constructor<?> constructor = null;
                for (Constructor<?> con : constructors) {
                    int parameterCount2 = con.getParameterCount();
                    if (values.length != parameterCount2) continue;
                    constructor = con;
                }
                if (constructor == null) {
                    if (!Null.class.isAssignableFrom(clazz)) {
                        logger.debug("can not find match constructor {}, {}, {}, {}", new Object[]{clazz, constructors, values.length, Arrays.stream(values).map(v -> v.getClass().getSimpleName()).collect(Collectors.toList())});
                    }
                    constructor = constructors[0];
                }
                if (constructors.length > 1) {
                    // empty if block
                }
                int parameterCount = constructor.getParameterCount();
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (values != null && parameterCount > values.length) {
                    params = new Object[parameterCount];
                    for (int i = 0; i < values.length; ++i) {
                        params[i] = values[i];
                    }
                } else {
                    params = values;
                }
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> parameterCount2 = parameterTypes[i];
                }
                Codec ret = null;
                try {
                    Object o = parameterCount > 0 ? constructor.newInstance(params) : constructor.newInstance(new Object[0]);
                    ret = (Codec)o;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ret == null) {
                    logger.error(" newInstance fail : {}, {}", constructors, (Object)values);
                }
                return ret;
            }

            @Override
            public Class<T> getTClass() {
                return clazz;
            }
        };
    }
}

