/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.type.extrinsics;

import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedBytes;
import java.util.LinkedHashMap;
import java.util.List;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.types.primitive.Method;

public class CreateUnchecked {
    public static Method.MethodFunction createDescriptor(final String section, final String method, int index, final Modules.FunctionMetadata meta) {
        final byte[] callIndex = new byte[]{UnsignedBytes.checkedCast((long)index), UnsignedBytes.checkedCast((long)meta.getId().toNumber())};
        final List<Modules.FunctionArgumentMetadata> expectedArgs = Method.filterOrigin(meta);
        Method.MethodFunction extrinsicFn = new Method.MethodFunction(){

            @Override
            public Method apply(Object ... args) {
                assert (expectedArgs.size() == args.length) : "Extrinsic " + section + "." + method + " expects " + expectedArgs.size() + " arguments, got " + args.length;
                LinkedHashMap values = Maps.newLinkedHashMap();
                values.put("args", args);
                values.put("callIndex", callIndex);
                return new Method(values, meta);
            }

            @Override
            public Object toJson() {
                return meta.toJson();
            }
        };
        extrinsicFn.setCallIndex(callIndex);
        extrinsicFn.setMeta(meta);
        extrinsicFn.setMethod(method);
        extrinsicFn.setSection(section);
        return extrinsicFn;
    }
}

