/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example.promise;

import com.onehilltech.promises.Promise;
import java.util.concurrent.atomic.AtomicReference;
import org.polkadot.api.Types;
import org.polkadot.api.promise.ApiPromise;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.rpc.provider.ws.WsProvider;

public class E04_Unsubscribe {
    static String endPoint = "ws://127.0.0.1:9944";

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        E04_Unsubscribe.initEndPoint(args);
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        AtomicReference unsubscribe = new AtomicReference();
        ready.then(api -> {
            Promise invoke = (Promise)((Types.DecoratedRpcMethod)api.rpc().chain().function("subscribeNewHead")).invoke(header -> System.out.println("Chain is at block: " + header.getBlockNumber()));
            return invoke;
        }).then(result -> {
            unsubscribe.set(result);
            AtomicReference atomicReference = unsubscribe;
            synchronized (atomicReference) {
                unsubscribe.notify();
            }
            System.out.println(" init unsubscribe ");
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return Promise.value((Object)err);
        });
        AtomicReference atomicReference = unsubscribe;
        synchronized (atomicReference) {
            unsubscribe.wait();
        }
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("do unsubscribe");
        if (unsubscribe.get() != null) {
            ((IRpcFunction.Unsubscribe)unsubscribe.get()).unsubscribe();
        }
    }
}

