/*
 * Decompiled with CFR 0.152.
 */
package com.onehilltech.promises;

import com.onehilltech.promises.AwaitHandler;
import com.onehilltech.promises.ContinuationPromise;
import com.onehilltech.promises.DeadlineAwaitHandler;
import com.onehilltech.promises.OnRejected;
import com.onehilltech.promises.OnRejectedExecutor;
import com.onehilltech.promises.OnRejectedNoReturn;
import com.onehilltech.promises.OnResolved;
import com.onehilltech.promises.OnResolvedExecutor;
import com.onehilltech.promises.OnResolvedNoReturn;
import com.onehilltech.promises.PromiseExecutor;
import com.onehilltech.promises.RejectNoReturn;
import com.onehilltech.promises.ResolveNoReturn;
import com.onehilltech.promises.TimeAwaitHandler;
import com.onehilltech.promises.UninterruptiblyAwaitHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Promise<T> {
    public static final OnRejected ignoreReason = Promise.rejected(reason -> {});
    private T value_;
    private Status status_ = Status.Pending;
    private Future<?> future_;
    private Throwable rejection_;
    private final ReentrantReadWriteLock stateLock_ = new ReentrantReadWriteLock();
    private static final ExecutorService DEFAULT_EXECUTOR = Executors.newCachedThreadPool(new PromiseThreadFactory());
    private final PromiseExecutor<T> impl_;
    private final ExecutorService executor_;
    private final String name_;
    private final ArrayList<ContinuationPromise<?>> continuations_ = new ArrayList();
    private final ArrayList<PendingEntry<T, ?>> pendingEntries_ = new ArrayList();

    public static <T, U> OnResolved<T, U> resolved(ResolveNoReturn<T> resolveNoReturn) {
        return new OnResolvedNoReturn(resolveNoReturn);
    }

    public static OnRejected rejected(RejectNoReturn rejectNoReturn) {
        return new OnRejectedNoReturn(rejectNoReturn);
    }

    T getValue() {
        return this.value_;
    }

    Throwable getRejection() {
        return this.rejection_;
    }

    public static <T> T await(Promise<T> promise) throws Throwable {
        return Promise.await(promise, true);
    }

    public static <T> T await(Promise<T> promise, boolean interruptible) throws Throwable {
        AwaitHandler handler = interruptible ? new AwaitHandler() : new UninterruptiblyAwaitHandler();
        promise.then(handler)._catch(handler);
        return handler.await();
    }

    public static <T> T await(Promise<T> promise, Date deadline) throws Throwable {
        DeadlineAwaitHandler handler = new DeadlineAwaitHandler(deadline);
        promise.then(handler)._catch(handler);
        return handler.await();
    }

    public static <T> T await(Promise<T> promise, long nanos) throws Throwable {
        TimeAwaitHandler handler = new TimeAwaitHandler(nanos);
        promise.then(handler)._catch(handler);
        return handler.await();
    }

    public static <T> T await(Promise<T> promise, long time, TimeUnit unit) throws Throwable {
        return Promise.await(promise, unit.toNanos(time));
    }

    public Promise(PromiseExecutor<T> impl) {
        this(null, impl);
    }

    public Promise(String name, PromiseExecutor<T> impl) {
        this(name, impl, Status.Pending, null, null);
    }

    private Promise(T value) {
        this(null, null, Status.Resolved, value, null);
    }

    private Promise(Throwable reason) {
        this(null, null, Status.Rejected, null, reason);
    }

    private Promise(String name, PromiseExecutor<T> impl, Status status, T value, Throwable reason) {
        this.name_ = name;
        this.impl_ = impl;
        this.value_ = value;
        this.rejection_ = reason;
        this.status_ = status;
        this.executor_ = DEFAULT_EXECUTOR;
        if (this.status_ == Status.Pending && this.impl_ != null) {
            this.settlePromise();
        }
    }

    public String getName() {
        return this.name_;
    }

    public Status getStatus() {
        try {
            this.stateLock_.readLock().lock();
            Status status = this.status_;
            return status;
        }
        finally {
            this.stateLock_.readLock().unlock();
        }
    }

    public boolean isCancelled() {
        return this.getStatus() == Status.Cancelled;
    }

    public boolean isPending() {
        return this.getStatus() == Status.Pending;
    }

    public boolean isResolved() {
        return this.getStatus() == Status.Resolved;
    }

    public boolean isRejected() {
        return this.getStatus() == Status.Rejected;
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = this.cancelThis(mayInterruptIfRunning);
        return result &= this.cancelContinuations(mayInterruptIfRunning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelThis(boolean mayInterruptIfRunning) {
        try {
            this.stateLock_.writeLock().lock();
            if (this.status_ != Status.Pending || this.future_ == null) {
                boolean bl = false;
                return bl;
            }
            boolean result = this.future_.cancel(mayInterruptIfRunning);
            if (result) {
                this.status_ = Status.Cancelled;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.stateLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelContinuations(boolean mayInterruptIfRunning) {
        boolean result = true;
        ArrayList<ContinuationPromise<?>> arrayList = this.continuations_;
        synchronized (arrayList) {
            for (ContinuationPromise<?> continuation : this.continuations_) {
                result &= continuation.cancel(mayInterruptIfRunning);
            }
        }
        return result;
    }

    public <U> Promise<U> then(OnResolved<T, U> onResolved) {
        if (onResolved == null) {
            throw new IllegalStateException("The resolve handler cannot be null");
        }
        return this.then(onResolved, null);
    }

    public <U> Promise<U> then(OnResolvedExecutor<T, U> onResolved) {
        if (onResolved == null) {
            throw new IllegalStateException("The resolve handler cannot be null");
        }
        return this.then(onResolved, null);
    }

    public <U> Promise<U> then(OnResolved<T, U> onResolved, OnRejected onRejected) {
        return this.then(OnResolvedExecutor.wrapOrNull(onResolved), OnRejectedExecutor.wrapOrNull(onRejected));
    }

    public <U> Promise<U> _catch(OnRejected onRejected) {
        if (onRejected == null) {
            throw new IllegalStateException("The rejected handler cannot be null.");
        }
        return this.then(null, onRejected);
    }

    public <U> Promise<U> _catch(OnRejectedExecutor onRejected) {
        if (onRejected == null) {
            throw new IllegalStateException("The rejected handler cannot be null.");
        }
        return this.then(null, onRejected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> Promise<U> then(OnResolvedExecutor<T, U> onResolved, OnRejectedExecutor<U> onRejected) {
        Status status;
        ContinuationPromise<U> continuation = this.createContinuationPromise();
        ArrayList<ContinuationPromise<?>> arrayList = this.continuations_;
        synchronized (arrayList) {
            this.continuations_.add(continuation);
        }
        try {
            this.stateLock_.readLock().lock();
            status = this.status_;
        }
        finally {
            this.stateLock_.readLock().unlock();
        }
        switch (status) {
            case Pending: {
                this.pendingEntries_.add(new PendingEntry<T, U>(continuation, onResolved, onRejected));
                break;
            }
            case Resolved: {
                if (onResolved != null) {
                    onResolved.execute((Executor)this.executor_, this.value_, continuation);
                    break;
                }
                continuation.continueWithNull();
                break;
            }
            case Rejected: {
                if (onRejected != null) {
                    onRejected.execute((Executor)this.executor_, this.rejection_, continuation);
                    break;
                }
                continuation.continueWith(this.rejection_);
                break;
            }
            case Cancelled: {
                continuation.cancel();
            }
        }
        return continuation;
    }

    protected <U> ContinuationPromise<U> createContinuationPromise() {
        return new ContinuationPromise();
    }

    private void settlePromise() {
        this.future_ = this.executor_.submit(this::settlePromiseImpl);
    }

    private void settlePromiseImpl() {
        try {
            this.impl_.execute(new Settlement<T>(){

                @Override
                public void resolve(T value) {
                    Promise.this.onResolve(value);
                }

                @Override
                public void reject(Throwable reason) {
                    Promise.this.onReject(reason);
                }
            });
        }
        catch (Throwable e) {
            this.onReject(e);
        }
    }

    void onResolve(T value) {
        if (this.status_ != Status.Pending) {
            throw new IllegalStateException("Promise must be pending to resolve.");
        }
        try {
            this.stateLock_.writeLock().lock();
            if (this.status_ != Status.Pending) {
                throw new IllegalStateException("Promise must be pending to resolve");
            }
            this.status_ = Status.Resolved;
            this.value_ = value;
        }
        finally {
            this.stateLock_.writeLock().unlock();
        }
        if (!this.pendingEntries_.isEmpty()) {
            for (PendingEntry<T, ?> entry : this.pendingEntries_) {
                entry.resolved(this.executor_, value);
            }
            this.pendingEntries_.clear();
        }
    }

    void onReject(Throwable reason) {
        if (this.status_ != Status.Pending) {
            throw new IllegalStateException("Promise must be pending to resolve");
        }
        try {
            this.stateLock_.writeLock().lock();
            if (this.status_ != Status.Pending) {
                throw new IllegalStateException("Promise must be pending to resolve");
            }
            this.rejection_ = reason;
            this.status_ = Status.Rejected;
        }
        finally {
            this.stateLock_.writeLock().unlock();
        }
        if (!this.pendingEntries_.isEmpty()) {
            for (PendingEntry<T, ?> entry : this.pendingEntries_) {
                entry.rejected(this.executor_, reason);
            }
            this.pendingEntries_.clear();
        }
    }

    public static <T> Promise<T> resolve(T value) {
        return new Promise<T>(value);
    }

    public static <T> Promise<T> value(T value) {
        return new Promise<T>(value);
    }

    public static <T> Promise<T> reject(Throwable reason) {
        return new Promise<T>(reason);
    }

    public static Promise<List<Object>> all(Promise<?> ... promises) {
        return Promise.all(Arrays.asList(promises));
    }

    public static Promise<List<Object>> all(final List<Promise<?>> promises) {
        if (promises.isEmpty()) {
            return Promise.resolve(Collections.emptyList());
        }
        return new Promise<2>(new PromiseExecutor<List<Object>>(){

            @Override
            public void execute(final Settlement<List<Object>> settlement) {
                final ArrayList results = new ArrayList(promises.size());
                final Iterator iterator = promises.iterator();
                final OnRejected onRejected = reason -> {
                    settlement.reject(reason);
                    return null;
                };
                OnResolved onResolved = new OnResolved(){

                    public Promise onResolved(Object value) {
                        results.add(value);
                        if (iterator.hasNext()) {
                            Promise promise = (Promise)iterator.next();
                            promise.then(this, onRejected);
                        } else {
                            settlement.resolve(results);
                        }
                        return null;
                    }
                };
                Promise promise = (Promise)iterator.next();
                promise.then(onResolved, onRejected);
            }
        });
    }

    public static <U> Promise<U> race(Promise<U> ... promises) {
        return Promise.race(Arrays.asList(promises));
    }

    public static <U> Promise<U> race(List<Promise<U>> promises) {
        if (promises.isEmpty()) {
            return Promise.resolve(null);
        }
        Object lock = new Object();
        return new Promise(settlement -> {
            OnResolved onResolved = Promise.resolved(value -> {
                Object object = lock;
                synchronized (object) {
                    try {
                        settlement.resolve(value);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            OnRejected onRejected = Promise.rejected(reason -> {
                Object object = lock;
                synchronized (object) {
                    try {
                        settlement.reject(reason);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            for (Promise promise : promises) {
                promise.then(onResolved, onRejected);
            }
        });
    }

    private static class PendingEntry<T, U> {
        final ContinuationPromise<U> cont;
        final OnResolvedExecutor<T, U> onResolved;
        final OnRejectedExecutor<U> onRejected;

        PendingEntry(ContinuationPromise<U> cont, OnResolvedExecutor<T, U> onResolved, OnRejectedExecutor<U> onRejected) {
            this.cont = cont;
            this.onResolved = onResolved;
            this.onRejected = onRejected;
        }

        void resolved(Executor executor, T value) {
            if (this.onResolved != null) {
                this.onResolved.execute(executor, value, this.cont);
            } else if (this.onRejected != null) {
                this.onRejected.execute(executor, value, this.cont);
            }
        }

        void rejected(Executor executor, Throwable reason) {
            if (this.onRejected != null) {
                this.onRejected.execute(executor, reason, this.cont);
            } else if (this.onResolved != null) {
                this.onResolved.execute(executor, reason, this.cont);
            }
        }
    }

    private static class PromiseThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter_ = new AtomicInteger(0);

        private PromiseThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String threadName = "PromiseThread-" + this.counter_.getAndIncrement();
            return new Thread(runnable, threadName);
        }
    }

    public static enum Status {
        Pending,
        Resolved,
        Rejected,
        Cancelled;

    }

    public static interface Settlement<T> {
        public void resolve(T var1);

        public void reject(Throwable var1);
    }
}

