/*
 * Decompiled with CFR 0.152.
 */
package com.onehilltech.promises;

import com.onehilltech.promises.ContinuationPromise;
import com.onehilltech.promises.OnResolved;
import com.onehilltech.promises.Promise;
import java.util.concurrent.Executor;

public class OnResolvedExecutor<T, U> {
    private OnResolved<T, U> onResolved_;

    static <T, U> OnResolvedExecutor<T, U> wrapOrNull(OnResolved<T, U> onResolved) {
        return onResolved != null ? new OnResolvedExecutor<T, U>(onResolved) : null;
    }

    OnResolvedExecutor(OnResolved<T, U> onResolved) {
        this.onResolved_ = onResolved;
    }

    void execute(Executor executor, T value, ContinuationPromise<U> continuation) {
        executor.execute(() -> this.execute(value, continuation));
    }

    void execute(Executor executor, Throwable reason, ContinuationPromise<U> continuation) {
        executor.execute(() -> continuation.continueWith(reason));
    }

    void execute(T value, ContinuationPromise<U> continuation) {
        try {
            Promise<U> promise = this.onResolved_.onResolved(value);
            continuation.continueWith(promise);
        }
        catch (Throwable e) {
            continuation.continueWith(e);
        }
    }
}

