/*
 * Decompiled with CFR 0.152.
 */
package com.onehilltech.promises;

import com.onehilltech.promises.ContinuationPromise;
import com.onehilltech.promises.OnRejected;
import com.onehilltech.promises.Promise;
import java.util.concurrent.Executor;

public class OnRejectedExecutor<T> {
    private final OnRejected onRejected_;

    static <T> OnRejectedExecutor<T> wrapOrNull(OnRejected onRejected) {
        return onRejected != null ? new OnRejectedExecutor<T>(onRejected) : null;
    }

    OnRejectedExecutor(OnRejected onRejected) {
        this.onRejected_ = onRejected;
    }

    void execute(Executor executor, Throwable reason, ContinuationPromise<T> continuation) {
        executor.execute(() -> this.execute(reason, continuation));
    }

    void execute(Executor executor, Object value, ContinuationPromise continuation) {
        executor.execute(() -> {
            try {
                continuation.continueWith(Promise.resolve(value));
            }
            catch (Throwable t) {
                continuation.continueWith(t);
            }
        });
    }

    protected void execute(Throwable reason, ContinuationPromise<T> continuation) {
        try {
            Promise promise = this.onRejected_.onRejected(reason);
            continuation.continueWith(promise);
        }
        catch (Throwable t) {
            continuation.continueWith(t);
        }
    }
}

