/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonrpc4j.ErrorData;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.JsonRpcError;
import com.googlecode.jsonrpc4j.JsonRpcErrors;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.List;

public enum AnnotationsErrorResolver implements ErrorResolver
{
    INSTANCE;


    @Override
    public ErrorResolver.JsonError resolveError(Throwable thrownException, Method method, List<JsonNode> arguments) {
        JsonRpcError resolver = this.getResolverForException(thrownException, method);
        if (this.notFoundResolver(resolver)) {
            return null;
        }
        String message = this.hasErrorMessage(resolver) ? resolver.message() : thrownException.getMessage();
        return new ErrorResolver.JsonError(resolver.code(), message, new ErrorData(resolver.exception().getName(), message));
    }

    private JsonRpcError getResolverForException(Throwable thrownException, Method method) {
        JsonRpcErrors errors = ReflectionUtil.getAnnotation(method, JsonRpcErrors.class);
        if (this.hasAnnotations(errors)) {
            for (JsonRpcError errorDefined : errors.value()) {
                if (!this.isExceptionInstanceOfError(thrownException, errorDefined)) continue;
                return errorDefined;
            }
        }
        return null;
    }

    private boolean notFoundResolver(JsonRpcError resolver) {
        return resolver == null;
    }

    private boolean hasErrorMessage(JsonRpcError em) {
        return em.message() != null && em.message().trim().length() > 0;
    }

    private boolean hasAnnotations(JsonRpcErrors errors) {
        return errors != null;
    }

    private boolean isExceptionInstanceOfError(Throwable target, JsonRpcError em) {
        return em.exception().isInstance(target);
    }
}

