/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.utils;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageScanner {
    private static final Logger logger = LoggerFactory.getLogger(PackageScanner.class);

    private PackageScanner() {
    }

    public static Set<Class<?>> scan(String packageName, boolean recursive) {
        String packageDirName = packageName.replace('.', '/');
        try {
            LinkedHashSet classSet = new LinkedHashSet();
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    classSet.addAll(PackageScanner.findClassesInPackageByFile(packageName, filePath, recursive));
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                classSet.addAll(PackageScanner.findClassesInPackageByJar(packageName, url, recursive));
            }
            return classSet;
        }
        catch (IOException e) {
            logger.error("error happen while scanning package", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private static Set<Class<?>> findClassesInPackageByFile(String packageName, String packagePath, boolean recursive) {
        LinkedHashSet classSet = new LinkedHashSet();
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return classSet;
        }
        File[] dirfiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"));
        if (dirfiles == null) {
            return classSet;
        }
        for (File file2 : dirfiles) {
            if (file2.isDirectory()) {
                Set<Class<?>> subClassSet = PackageScanner.findClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), recursive);
                classSet.addAll(subClassSet);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - ".class".length());
            Class<?> clazz = PackageScanner.loadClass(packageName + "." + className);
            if (clazz == null) continue;
            classSet.add(clazz);
        }
        return classSet;
    }

    private static Set<Class<?>> findClassesInPackageByJar(String packageName, URL url, boolean recursive) {
        LinkedHashSet classSet = new LinkedHashSet();
        String packageDirName = packageName.replace('.', '/');
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - ".class".length());
                Class<?> clazz = PackageScanner.loadClass(packageName + "." + className);
                if (clazz == null) continue;
                classSet.add(clazz);
            }
        }
        catch (IOException e) {
            logger.error("error happen while scanning package", (Throwable)e);
        }
        return classSet;
    }

    private static Class<?> loadClass(String fullClassName) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(fullClassName);
        }
        catch (ClassNotFoundException e) {
            logger.error("error happen while scanning package", (Throwable)e);
            return null;
        }
    }
}

