/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.primitive;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.direct.IFunction;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.CreateType;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.U8a;
import org.polkadot.types.codec.U8aFixed;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.v0.Modules;
import org.polkadot.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Method
extends Struct
implements Types.IMethod {
    private static final Logger logger = LoggerFactory.getLogger(Method.class);
    static final Map<String, MethodFunction> INJECTED = new HashMap<String, MethodFunction>();
    static final MethodFunction FN_UNKNOWN = new MethodFunction(){

        @Override
        public Method apply(Object ... args) {
            return null;
        }

        @Override
        public Object toJson() {
            return null;
        }
    };
    protected Modules.FunctionMetadata meta;

    public Method(Object value, Modules.FunctionMetadata meta) {
        super(new Types.ConstructorDef().add("callIndex", MethodIndex.class).add("args", Struct.with(Method.decodeMethod((Object)value, (Modules.FunctionMetadata)meta).argsDef)), Method.decodeMethod(value, meta));
        this.meta = Method.decodeMethod((Object)value, (Modules.FunctionMetadata)meta).meta;
    }

    private static DecodedMethod decodeMethod(Object value, Modules.FunctionMetadata meta) {
        if (Utils.isHex(value)) {
            return Method.decodeMethod(Utils.hexToU8a((String)value), meta);
        }
        if (Utils.isU8a(value)) {
            byte[] u8a = Utils.u8aToU8a(value);
            byte[] callIndex = ArrayUtils.subarray((byte[])u8a, (int)0, (int)2);
            Modules.FunctionMetadata fMeta = meta;
            if (fMeta == null) {
                fMeta = Method.findFunction((byte[])callIndex).meta;
            }
            return new DecodedMethod(ArrayUtils.subarray((byte[])u8a, (int)2, (int)u8a.length), new MethodIndex(callIndex), Method.getArgsDef(fMeta), fMeta);
        }
        if (value instanceof Map || value instanceof Types.IMethod) {
            List<Codec> args = null;
            MethodIndex callIndex = null;
            if (value instanceof Types.IMethod) {
                args = ((Types.IMethod)value).getArgs();
                callIndex = new MethodIndex(((Types.IMethod)value).getCallIndex());
            } else {
                Map struct = (Map)value;
                args = struct.get("args");
                callIndex = new MethodIndex(struct.get("callIndex"));
            }
            byte[] lookupIndex = null;
            lookupIndex = callIndex instanceof MethodIndex ? callIndex.toU8a() : Utils.u8aToU8a(callIndex);
            Modules.FunctionMetadata fMeta = meta;
            if (fMeta == null) {
                fMeta = Method.findFunction((byte[])lookupIndex).meta;
            }
            return new DecodedMethod(args, callIndex, Method.getArgsDef(fMeta), fMeta);
        }
        logger.error("Method: cannot decode value {} of type {}", value, value.getClass());
        return new DecodedMethod(new U8a(new byte[0]), new MethodIndex(new byte[]{-1, -1}), new Types.ConstructorDef(), new Modules.FunctionMetadata((Object)null));
    }

    static MethodFunction findFunction(byte[] callIndex) {
        return INJECTED.getOrDefault(Arrays.toString(callIndex), FN_UNKNOWN);
    }

    private static Types.ConstructorDef getArgsDef(Modules.FunctionMetadata meta) {
        Types.ConstructorDef constructorDef = new Types.ConstructorDef();
        Method.filterOrigin(meta).stream().forEach((? super T argumentMetadata) -> {
            Types.ConstructorCodec type = CreateType.getTypeClass(CreateType.getTypeDef(argumentMetadata.getType().toString(), null));
            constructorDef.add(argumentMetadata.getName().toString(), type);
        });
        return constructorDef;
    }

    public static List<Modules.FunctionArgumentMetadata> filterOrigin(Modules.FunctionMetadata meta) {
        if (meta != null) {
            Vector<Modules.FunctionArgumentMetadata> arguments = meta.getArguments();
            List<Modules.FunctionArgumentMetadata> ret = arguments.stream().filter(argument -> !argument.getType().toString().equals("Origin")).collect(Collectors.toList());
            return ret;
        }
        return Collections.emptyList();
    }

    public static void injectMethods(ModulesWithMethods moduleMethods) {
        moduleMethods.forEach((k, v) -> v.forEach((ik, iv) -> INJECTED.put(Arrays.toString(iv.callIndex), (MethodFunction)iv)));
    }

    @Override
    public List<Codec> getArgs() {
        Struct args = (Struct)this.getField("args");
        return args.values().stream().collect(Collectors.toList());
    }

    @Override
    public Types.ConstructorDef getArgsDef() {
        return Method.getArgsDef(this.meta);
    }

    @Override
    public byte[] getCallIndex() {
        MethodIndex callIndex = (MethodIndex)this.getField("callIndex");
        return callIndex.toU8a(false);
    }

    @Override
    public byte[] getData() {
        Struct args = (Struct)this.getField("args");
        return args.toU8a(false);
    }

    @Override
    public boolean hasOrigin() {
        Vector arguments = (Vector)this.meta.getField("arguments");
        Modules.FunctionArgumentMetadata firstArg = arguments.size() > 0 ? (Modules.FunctionArgumentMetadata)arguments.get(0) : null;
        return firstArg != null && firstArg.getType().toString().equals("Origin");
    }

    @Override
    public Modules.FunctionMetadata getMeta() {
        return this.meta;
    }

    public static class ModulesWithMethods
    extends LinkedHashMap<String, Methods> {
    }

    public static class Methods
    extends LinkedHashMap<String, MethodFunction> {
    }

    public static abstract class MethodFunction
    implements IFunction {
        byte[] callIndex;
        Modules.FunctionMetadata meta;
        String method;
        String section;

        public abstract Method apply(Object ... var1);

        public abstract Object toJson();

        public byte[] getCallIndex() {
            return this.callIndex;
        }

        public void setCallIndex(byte[] callIndex) {
            this.callIndex = callIndex;
        }

        public Modules.FunctionMetadata getMeta() {
            return this.meta;
        }

        public void setMeta(Modules.FunctionMetadata meta) {
            this.meta = meta;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getSection() {
            return this.section;
        }

        public void setSection(String section) {
            this.section = section;
        }
    }

    public static class DecodedMethod
    extends DecodeMethodInput {
        public Types.ConstructorDef argsDef;
        public Modules.FunctionMetadata meta;

        public DecodedMethod(Object args, MethodIndex callIndex, Types.ConstructorDef argsDef, Modules.FunctionMetadata meta) {
            super(args, callIndex);
            this.argsDef = argsDef;
            this.meta = meta;
        }

        public Types.ConstructorDef getArgsDef() {
            return this.argsDef;
        }

        public Modules.FunctionMetadata getMeta() {
            return this.meta;
        }
    }

    public static class DecodeMethodInput {
        public Object args;
        public MethodIndex callIndex;

        public DecodeMethodInput(Object args, MethodIndex callIndex) {
            this.args = args;
            this.callIndex = callIndex;
        }

        public Object getArgs() {
            return this.args;
        }

        public MethodIndex getCallIndex() {
            return this.callIndex;
        }
    }

    public static class MethodIndex
    extends U8aFixed {
        public MethodIndex(Object value) {
            super(value, 16);
        }
    }
}

