/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.metadata.v1;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.codec.Option;
import org.polkadot.types.codec.Struct;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.metadata.MetadataUtils;
import org.polkadot.types.metadata.Types;
import org.polkadot.types.metadata.v1.Calls;
import org.polkadot.types.metadata.v1.Events;
import org.polkadot.types.metadata.v1.Storage;
import org.polkadot.types.primitive.Text;

public class MetadataV1
extends Struct
implements Types.MetadataInterface {
    public MetadataV1(Object value) {
        super(new Types.ConstructorDef().add("modules", Vector.with(TypesUtils.getConstructorCodec(MetadataModule.class))), value);
    }

    Vector<MetadataModule> getModules() {
        return (Vector)this.getField("modules");
    }

    private List getCallNames() {
        return this.getModules().stream().map(mod -> mod.getCalls().isNone() ? Lists.newArrayList() : mod.getCalls().unwrap().stream().map(fn -> fn.getArgs().stream().map(arg -> arg.getType().toString()).collect(Collectors.toList())).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List getEventNames() {
        return this.getModules().stream().map(mod -> mod.getEvents().isNone() ? Lists.newArrayList() : mod.getEvents().unwrap().stream().map(event -> event.getArgs().stream().map(arg -> arg.toString()).collect(Collectors.toList())).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List getStorageNames() {
        return this.getModules().stream().map(mod -> mod.getStorage().isNone() ? Lists.newArrayList() : mod.getStorage().unwrap().stream().map(fn -> fn.getType().isMap() ? Lists.newArrayList((Object[])new String[]{fn.getType().asMap().getKey().toString(), fn.getType().asMap().getValue().toString()}) : Lists.newArrayList((Object[])new String[]{fn.getType().asType().toString()})).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @Override
    public List<String> getUniqTypes(boolean throwError) {
        List<Object> types = MetadataUtils.flattenUniq(Lists.newArrayList((Object[])new Object[]{this.getCallNames(), this.getEventNames(), this.getStorageNames()}));
        ArrayList<String> ret = new ArrayList<String>();
        types.forEach((? super T type) -> ret.add((String)type));
        MetadataUtils.validateTypes(ret, throwError);
        return null;
    }

    public static class MetadataModule
    extends Struct {
        public MetadataModule(Object value) {
            super(new Types.ConstructorDef().add("name", Text.class).add("prefix", Text.class).add("storage", Option.with(Vector.with(TypesUtils.getConstructorCodec(Storage.MetadataStorageV1.class)))).add("calls", Option.with(Vector.with(TypesUtils.getConstructorCodec(Calls.MetadataCall.class)))).add("events", Option.with(Vector.with(TypesUtils.getConstructorCodec(Events.MetadataEvent.class)))), value);
        }

        public Option<Vector<Calls.MetadataCall>> getCalls() {
            return (Option)this.getField("calls");
        }

        public Option<Vector<Events.MetadataEvent>> getEvents() {
            return (Option)this.getField("events");
        }

        public Text getName() {
            return (Text)this.getField("name");
        }

        public Text getPrefix() {
            return (Text)this.getField("prefix");
        }

        public Option<Vector<Storage.MetadataStorageV1>> getStorage() {
            return (Option)this.getField("storage");
        }
    }
}

