/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.google.common.collect.Lists;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.AbstractArray;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.utils.Utils;

public class Vector<T extends Codec>
extends AbstractArray<T> {
    private Types.ConstructorCodec<T> type;

    public Vector(Types.ConstructorCodec<T> type, Object value) {
        this.type = type;
        this.addAll(Vector.decodeVector(type, value));
    }

    static <T extends Codec> List<T> decodeVector(Types.ConstructorCodec<T> type, Object value) {
        ArrayList ret = new ArrayList();
        if (value instanceof List) {
            for (Object obj : (List)value) {
                Vector.genInstance(ret, type, obj);
            }
            return ret;
        }
        if (value != null && value.getClass().isArray() && !(value instanceof byte[])) {
            List<Object> objects = CodecUtils.arrayLikeToList(value);
            for (Object obj : objects) {
                Vector.genInstance(ret, type, obj);
            }
            return ret;
        }
        byte[] u8a = Utils.u8aToU8a(value);
        Pair<Integer, BigInteger> pair = Utils.compactFromU8a(u8a);
        int offset = (Integer)pair.getKey();
        int length = ((BigInteger)pair.getValue()).intValue();
        ArrayList<Types.ConstructorCodec> typeList = new ArrayList<Types.ConstructorCodec>();
        for (int i = 0; i < length; ++i) {
            typeList.add(type);
        }
        ArrayList results = Lists.newArrayList();
        CodecUtils.decodeU8a(ArrayUtils.subarray((byte[])u8a, (int)offset, (int)u8a.length), typeList, results);
        return results;
    }

    private static <T extends Codec> void genInstance(List<T> all, Types.ConstructorCodec<T> type, Object value) {
        Class<T> tClass = type.getTClass();
        if (tClass.isInstance(value) && !Utils.isContainer(value)) {
            all.add((Codec)value);
        } else {
            T t1 = type.newInstance(value);
            all.add(t1);
        }
    }

    public static <O extends Codec> Types.ConstructorCodec<Vector<O>> with(Types.ConstructorCodec<O> type) {
        return new Builder<O>(type);
    }

    public String getType() {
        return this.type.toString();
    }

    @Override
    public int indexOf(Object o) {
        Type gType = ((ParameterizedType)this.type.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Object o1 = null;
        o1 = gType instanceof Class && o.getClass().isAssignableFrom((Class)gType) ? o : this.type.newInstance(o);
        return super.indexOf(o1);
    }

    static class Builder<T extends Codec>
    implements Types.ConstructorCodec<Vector> {
        Types.ConstructorCodec<T> type;

        Builder(Types.ConstructorCodec<T> type) {
            this.type = type;
        }

        @Override
        public Vector newInstance(Object ... values) {
            return new Vector<T>(this.type, values[0]);
        }

        @Override
        public Class<Vector> getTClass() {
            return Vector.class;
        }
    }
}

