/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.TypesUtils;
import org.polkadot.types.primitive.Bool;
import org.polkadot.types.primitive.I128;
import org.polkadot.types.primitive.I16;
import org.polkadot.types.primitive.I256;
import org.polkadot.types.primitive.I32;
import org.polkadot.types.primitive.I64;
import org.polkadot.types.primitive.I8;
import org.polkadot.types.primitive.U128;
import org.polkadot.types.primitive.U16;
import org.polkadot.types.primitive.U256;
import org.polkadot.types.primitive.U32;
import org.polkadot.types.primitive.U64;
import org.polkadot.types.primitive.U8;
import org.polkadot.types.primitive.USize;
import org.polkadot.utils.PackageScanner;

public class TypeRegistry {
    private static volatile TypeRegistry defaultRegistry = null;
    private static Map<String, Types.ConstructorCodec> registry = new HashMap<String, Types.ConstructorCodec>();

    void registerClass(Class<? extends Codec> clazz) {
        Types.ConstructorCodec<? extends Codec> builder = TypesUtils.getConstructorCodec(clazz);
        registry.put(clazz.getSimpleName(), builder);
    }

    void register(String name, Types.ConstructorCodec type) {
        registry.put(name, type);
    }

    void registerObject(Types.RegistryTypes object, boolean overwrite) {
        throw new UnsupportedOperationException();
    }

    public Types.ConstructorCodec get(String name) {
        return registry.get(name);
    }

    public Types.ConstructorCodec getOrThrow(String name, String msg) {
        Types.ConstructorCodec type = this.get(name);
        if (type == null) {
            throw new RuntimeException(msg);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeRegistry getDefaultRegistry() {
        if (defaultRegistry != null) return defaultRegistry;
        Class<TypeRegistry> clazz = TypeRegistry.class;
        synchronized (TypeRegistry.class) {
            if (defaultRegistry != null) return defaultRegistry;
            TypeRegistry registry = new TypeRegistry();
            TypeRegistry.registerPackage("org.polkadot.types.metadata", registry);
            TypeRegistry.registerPackage("org.polkadot.types.primitive", registry);
            TypeRegistry.registerPackage("org.polkadot.types.rpc", registry);
            TypeRegistry.registerPackage("org.polkadot.types.type", registry);
            TypeRegistry.registerAlias(registry);
            defaultRegistry = registry;
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultRegistry;
        }
    }

    private static void registerAlias(TypeRegistry typeRegistry) {
        HashSet aliasClass = Sets.newHashSet((Object[])new Class[]{U8.class, U16.class, U32.class, U64.class, U128.class, U256.class, USize.class, Bool.class, I8.class, I16.class, I32.class, I64.class, I128.class, I256.class});
        for (Class aClass : aliasClass) {
            Types.ConstructorCodec builder = TypesUtils.getConstructorCodec(aClass);
            registry.put(aClass.getSimpleName().toLowerCase(), builder);
        }
    }

    public static void registerTypes(Map<String, Types.ConstructorCodec> types) {
        TypeRegistry defaultRegistry = TypeRegistry.getDefaultRegistry();
        registry.putAll(types);
    }

    public static void main(String[] args) {
        TypeRegistry.getDefaultRegistry();
    }

    private static void registerPackage(String packageName, TypeRegistry typeRegistry) {
        Set<Class<?>> classSet = PackageScanner.scan(packageName, true);
        for (Class<?> clazz : classSet) {
            if (!Codec.class.isAssignableFrom(clazz)) continue;
            typeRegistry.registerClass(clazz);
        }
    }
}

