/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import org.apache.commons.lang3.ArrayUtils;
import org.polkadot.types.Codec;
import org.polkadot.types.Types;
import org.polkadot.types.codec.Base;
import org.polkadot.types.primitive.Null;
import org.polkadot.types.primitive.Type;
import org.polkadot.utils.Utils;

public class Option<T extends Codec>
extends Base<T>
implements Codec {
    public Option(Types.ConstructorCodec type, Object value) {
        super(Option.decodeOption(type, value));
    }

    static <O> Codec decodeOption(Types.ConstructorCodec type, Object value) {
        if (value == null || value instanceof Null) {
            return new Null();
        }
        if (value instanceof Option) {
            return Option.decodeOption(type, ((Option)value).getValue());
        }
        if (value instanceof Type) {
            return (Codec)value;
        }
        if (Utils.isU8a(value)) {
            byte[] bytes = Utils.u8aToU8a(value);
            return bytes[0] == 0 ? new Null() : type.newInstance(new Object[]{ArrayUtils.subarray((byte[])bytes, (int)1, (int)bytes.length)});
        }
        return type.newInstance(value);
    }

    public static <O> Types.ConstructorCodec<Option> with(Types.ConstructorCodec type) {
        return new Builder(type);
    }

    @Override
    public int getEncodedLength() {
        return 1 + ((Codec)this.raw).getEncodedLength();
    }

    public boolean isNone() {
        return this.raw instanceof Null;
    }

    public boolean isSome() {
        return !this.isNone();
    }

    @Override
    public boolean isEmpty() {
        return this.isNone();
    }

    @Override
    public boolean eq(Object other) {
        if (other instanceof Option) {
            return this.isSome() && ((Option)other).isSome() && this.getValue().eq(((Option)other).getValue());
        }
        return this.getValue().eq(other);
    }

    @Override
    public String toHex() {
        return Utils.u8aToHex(this.toU8a(false));
    }

    @Override
    public Object toJson() {
        return ((Codec)this.raw).toJson();
    }

    public String toString() {
        return ((Codec)this.raw).toString();
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        if (isBare) {
            return ((Codec)this.raw).toU8a(true);
        }
        byte[] u8a = new byte[this.getEncodedLength()];
        if (this.isSome()) {
            byte[] rawBytes = ((Codec)this.raw).toU8a(false);
            u8a[0] = 1;
            System.arraycopy(rawBytes, 0, u8a, 1, rawBytes.length);
        }
        return u8a;
    }

    public T unwrap() {
        if (this.isNone()) {
            throw new RuntimeException("Option: unwrapping a None value");
        }
        return (T)((Codec)this.raw);
    }

    public <O> Object unwrapOr(O defaultValue) {
        return this.isSome() ? this.unwrap() : defaultValue;
    }

    public Codec getValue() {
        return (Codec)this.raw;
    }

    static class Builder
    implements Types.ConstructorCodec<Option> {
        Types.ConstructorCodec type;

        public Builder(Types.ConstructorCodec type) {
            this.type = type;
        }

        @Override
        public Option newInstance(Object ... values) {
            return new Option(this.type, values[0]);
        }

        @Override
        public Class<Option> getTClass() {
            return Option.class;
        }
    }
}

