/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.types.codec;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.polkadot.types.Codec;
import org.polkadot.types.codec.CodecUtils;
import org.polkadot.utils.Utils;

public class AbstractArray<T extends Codec>
extends ArrayList<T>
implements Codec {
    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int length() {
        return this.size();
    }

    @Override
    public int getEncodedLength() {
        int total = 0;
        for (Codec t : this) {
            total += t.getEncodedLength();
        }
        return total += Utils.compactToU8a(this.size()).length;
    }

    @Override
    public boolean eq(Object other) {
        return CodecUtils.compareArray(this, other);
    }

    @Override
    public String toHex() {
        return Utils.u8aToHex(this.toU8a());
    }

    @Override
    public Object toJson() {
        List collect = this.stream().map(e -> e.toJson()).collect(Collectors.toList());
        return JSONArray.toJSON(collect);
    }

    @Override
    public byte[] toU8a(boolean isBare) {
        List<byte[]> encoded = this.stream().map(e -> e.toU8a(isBare)).collect(Collectors.toList());
        if (!isBare) {
            encoded.add(0, Utils.compactToU8a(this.length()));
        }
        return Utils.u8aConcat(encoded);
    }

    public <T> T getFiled(int index) {
        return (T)this.get(index);
    }
}

