/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.example.promise;

import com.onehilltech.promises.Promise;
import org.polkadot.api.SubmittableExtrinsic;
import org.polkadot.api.Types;
import org.polkadot.api.promise.ApiPromise;
import org.polkadot.common.keyring.Keyring;
import org.polkadot.common.keyring.Types;
import org.polkadot.rpc.provider.ws.WsProvider;
import org.polkadot.types.Types;
import org.polkadot.types.type.Hash;

public class E06_MakeTransfer {
    static String Alice = "5GrwvaEF5zXb26Fz9rcQpDWS57CtERHpNehXCPcNoHGKutQY";
    static String endPoint = "ws://127.0.0.1:9944";

    static void initEndPoint(String[] args) {
        if (args != null && args.length >= 1) {
            endPoint = args[0];
            System.out.println(" connect to endpoint [" + endPoint + "]");
        } else {
            System.out.println(" connect to default endpoint [" + endPoint + "]");
        }
    }

    public static void main(String[] args) throws InterruptedException {
        E06_MakeTransfer.initEndPoint(args);
        WsProvider wsProvider = new WsProvider(endPoint);
        Promise<ApiPromise> ready = ApiPromise.create(wsProvider);
        String BOB = "5FHneW46xGXgs5mUiveU4sbTyGBzmstUspZC92UhjJM694ty";
        ready.then(api -> {
            Types.KeyringOptions options = new Types.KeyringOptions("sr25519");
            Keyring keyring = new Keyring(options);
            Types.KeyringPair alice = keyring.addFromUri("//Alice", null, options.getType());
            Types.SubmittableExtrinsicFunction function = (Types.SubmittableExtrinsicFunction)api.tx().section("balances").function("transfer");
            SubmittableExtrinsic transfer = function.call(BOB, 111);
            return (Promise)transfer.signAndSend(alice, new Types.SignatureOptions());
        }).then(result -> {
            Hash hash = (Hash)result;
            System.out.println("Transfer sent with hash" + hash.toHex());
            return null;
        })._catch(err -> {
            err.printStackTrace();
            return null;
        });
    }

    static {
        System.loadLibrary("jni");
        System.out.println("load ");
    }
}

