/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.common.keyring;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.polkadot.common.keyring.Types;
import org.polkadot.common.keyring.address.AddressCodec;
import org.polkadot.utils.Utils;

public class Pairs
implements Types.KeyringPairs {
    private KeyringPairMap map = new KeyringPairMap();

    @Override
    public Types.KeyringPair add(Types.KeyringPair pair) {
        this.map.put(Arrays.toString(pair.publicKey()), pair);
        return pair;
    }

    @Override
    public List<Types.KeyringPair> all() {
        return Lists.newArrayList(this.map.values());
    }

    @Override
    public Types.KeyringPair get(String address) {
        byte[] key = AddressCodec.decodeAddress(address);
        Types.KeyringPair pair = (Types.KeyringPair)this.map.get(Arrays.toString(key));
        if (pair == null) {
            String formatted = Utils.isU8a(address) || Utils.isHex(address) ? Utils.u8aToHex(Utils.u8aToU8a(address)) : address;
            throw new RuntimeException("Unable to retrieve keypair" + formatted);
        }
        return pair;
    }

    @Override
    public void remove(String address) {
        byte[] decodeAddress = AddressCodec.decodeAddress(address);
        this.map.remove(Arrays.toString(decodeAddress));
    }

    public static class KeyringPairMap
    extends LinkedHashMap<String, Types.KeyringPair> {
    }
}

